/*
 * 2015-2020 Bonpresta
 *
 * Bonpresta Wishlist
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the General Public License (GPL 2.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/GPL-2.0
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade the module to newer
 * versions in the future.
 *
 *  @author    Bonpresta
 *  @copyright 2015-2020 Bonpresta
 *  @license   http://opensource.org/licenses/GPL-2.0 General Public License (GPL 2.0)
 */

window.onload = function () {

    bonWishList();
    addClass();

    prestashop.on("updateProductList", () => {
        bonWishList();
        addClass();
    });

    prestashop.on("updatedProduct", () => {
        bonWishList();
        addClass();
    });

}

let stored_wishList = localStorage.getItem("wishList");
let wishList = stored_wishList ? JSON.parse(stored_wishList) : [];

function bonWishList() {
    let wishButtons = document.getElementsByClassName('wish-button');
    wishButtons = Array.prototype.slice.call(wishButtons);

    wishButtons.forEach(function (wishButton) {

        wishButton.onclick = function () {

            event.preventDefault();
            event.stopPropagation();
            let productId = wishButton.parentNode.getAttribute('data-id-product');

            function prodIndex(value) {
                return value == productId;
            }

            let index = wishList.findIndex(prodIndex);

            if (wishList.indexOf(productId) == -1) {

                wishList.push(productId);
                pushToStorage(wishList);
                $(this).addClass('active');
            } else {

                wishList.splice(index, 1);
                pushToStorage(wishList);
                $(this).removeClass('active');

            }
            stored_wishList = localStorage.getItem("wishList");
            wishList = stored_wishList ? JSON.parse(stored_wishList) : [];

            if (wishList.length == 0) {
                $('#bonwishlist .no-items-js.alert.alert-info').css('display', 'block');
            }
            ajaxRequest();
        }

        if (stored_wishList && wishList.length > 0) {
            ajaxRequest();
        }
        counter();
    });

    function pushToStorage(arr) {
        localStorage.setItem("wishList", JSON.stringify(arr));
    }

    responsiveWishlist();

    prestashop.on("updateProductList", () => {
        addClass();
    });
}

function ajaxRequest() {

    const url = bon_wishlist_url;
    let params = 'wishlist_key=' + wishList;
    const request = new XMLHttpRequest();

    request.responseType = "";
    request.open("POST", url, true);
    request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    request.addEventListener("readystatechange", () => {


        if ($('.wishlist-item').length == 0) {
            $('.no-items-js').addClass('block');

        } else if ($('.wishlist-item').length > 0) {
            $('.no-items-js').removeClass('block');
        }

        if (request.readyState === 4 && request.status === 200) {

            let obj = request.response;
            $('#wishlist-popup').innerHTML = obj;
            $("#wishlist-popup").html(obj);
            let wishDelete = document.getElementsByClassName('wishlist-button-delete');
            wishDelete = Array.prototype.slice.call(wishDelete);

            wishDelete.forEach(function (button, j) {
                button.onclick = function () {
                    let articles = document.getElementsByClassName('wishlist-item');
                    let wishListLength = articles.length;
                    let wishlistFooter = document.getElementById('wishlist-footer');
                    let noItems = document.querySelector('.no-items-js');
                    let wishItem = button.parentNode;
                    wishItem.parentNode.removeChild(wishItem);
                    let productId = button.parentNode.getAttribute('data-id-product');

                    function prodIndex(value) {
                        return value == productId;
                    }
                    let index = wishList.findIndex(prodIndex);
                    wishList.splice(index, 1);
                    $(this).removeClass('active');
                    localStorage.setItem("wishList", JSON.stringify(wishList));
                    if (wishListLength < 2) {
                        noItems.classList.add('block')
                        $('.wishlist-wrapper').addClass('none');
                        // wishlistFooter.classList.add('none');
                    }
                    let articlesList = document.getElementsByClassName('bonwishlist-hook-wrapper');
                    articlesList = Array.prototype.slice.call(articlesList);
                    for (let i = 0; i < articlesList.length; i++) {
                        articleId = articlesList[i].getAttribute('data-id-product');
                        if (productId == articleId) {
                            let article = articlesList[i];
                            let button = $(article).children(".wish-button").get();
                            for (let k = 0; k < button.length; k++) {
                                button[k].classList.remove('active');
                            }
                        }
                    }
                    counter();
                }
            });
            counter();
        }
    });

    if (stored_wishList && wishList.length > 0) {
        request.send(params);
        $('#wishlist-popup').css('display', 'block');
        $('#bonwishlist .no-items-js.alert.alert-info').css('display', 'none');


    } else if (!stored_wishList || wishList.length <= 0) {
        $('#wishlist-popup').css('display', 'none')
    }
    counter();
}

function counter() {
    let articles = document.getElementsByClassName('wishlist-item');
    let counter = document.getElementById('wishlist-count');
    let wishListLength = articles.length;
    counter.innerHTML = wishListLength;
    if (!stored_wishList || wishList.length <= 0) {
        counter.innerHTML = 0
    }
}

function addClass() {

    let articles = document.getElementsByClassName('bonwishlist-hook-wrapper');
    articles = Array.prototype.slice.call(articles);

    for (let i = 0; i < articles.length; i++) {
        articleId = articles[i].getAttribute('data-id-product');

        if (wishList.indexOf(articleId) != -1) {
            let article = articles[i];

            let button = $(article).children(".wish-button").get();

            for (let k = 0; k < button.length; k++) {

                button[k].classList.add('active');
            }
        }
    }
}

$(window).on('resize', function () {
    responsiveWishlist();
});

function responsiveWishlist() {
    if ($(window).width() < 767) {
        $('#bonwishlist').appendTo($('#_mobile_bonwishlist'));
    } else {
        $('#bonwishlist').insertAfter($('#_desktop_search_widget'));
    }
}