<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class DropinblogFeedModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();

        // api params
        $apiParams = [
            'limit' => Tools::getValue('limit', 10),
            'type' => Tools::getValue('type', null),
        ];

        // feed url
        $feedUrl = Configuration::get('DROPINBLOG_API_URL') . '/' . Configuration::get('DROPINBLOG_ID') . '/feed';
        if (Tools::getValue('categoryslug')) {
            $feedUrl .= '/category/' . urlencode(Tools::getValue('categoryslug'));
        } elseif (Tools::getValue('authorslug')) {
            $feedUrl .= '/author/' . urlencode(Tools::getValue('authorslug'));
        }

        // get the feed
        $guzzleClient = new \GuzzleHttp\Client();
        $response = $guzzleClient->get($feedUrl . '?' . http_build_query($apiParams));

        // headers
        $contentType = 'application/rss+xml';
        if (Tools::getValue('type') == 'atom') {
            $contentType = 'application/atom+xml';
        }
        header('content-type: ' . $contentType);

        // output the feed
        echo $response->getBody();
    }
}
