<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class DropinblogListModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();

        // api params
        $apiParams = [
            'b' => Configuration::get('DROPINBLOG_ID'),
            'page' => Tools::getValue('page', 1),
            'c' => Tools::getValue('categoryslug', null),
            'a' => Tools::getValue('authorslug', null),
            'sq' => Tools::getValue('sq', null),
            'format' => 'json',
        ];

        // get the blog data
        $guzzleClient = new \GuzzleHttp\Client();
        $response = $guzzleClient->get(Configuration::get('DROPINBLOG_API_URL') . '?' . http_build_query($apiParams));
        $blogResponse = json_decode($response->getBody());
        $blogData = $blogResponse->data;

        if ($blogResponse->status == 'failed') {
            // headers
            header('HTTP/1.1 404 Not Found');
            header('Status: 404 Not Found');

            // assign data to smarty
            $this->context->smarty->assign([
                'blogData' => $blogData,
            ]);

            // set the 404 template
            $this->setTemplate('module:dropinblog/views/templates/front/404.tpl');
        } else {
            // update page data
            $page = parent::getTemplateVarPage();
            $page['meta']['title'] = $blogData->headTitle;
            $page['meta']['description'] = $blogData->headDescription;
            $page['meta']['robots'] = (Tools::getValue('sq') ? 'noindex' : 'index');
            $page['canonical'] = $blogData->canonicalUrl;

            // assign data to smarty
            $this->context->smarty->assign([
                'blogData' => $blogData,
                'page' => $page,
            ]);

            // set the template
            $this->setTemplate('module:dropinblog/views/templates/front/list.tpl');
        }
    }
}
