{*
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
*}

<link href="{$pathVendor|escape:'htmlall':'UTF-8'}" rel=preload as=script>
<link href="{$pathApp|escape:'htmlall':'UTF-8'}" rel=preload as=script>
<link href="{$urlAccountsCdn|escape:'htmlall':'UTF-8'}" rel=preload as=script>

{if $showSettings}
<div style="margin-top: 20px;">
    {$alertOutput}
    <form action="" method="post" class="defaultForm form-horizontal" style="margin-top: 20px;">
        <div class="panel panel-default">
            <div class="panel-heading">Settings</div>
            <div class="panel-body">
                <div class="row">
                    <div class="col-md-6">
                        <div style="margin-bottom: 30px;">
                            <div class="form-group">
                                <h4><strong>General</strong></h4>
                                <label for="directory">Blog URL</label>
                                <div class="input-group">
                                    <span class="input-group-addon" id="basic-addon3">{$baseUrl|escape:'htmlall':'UTF-8'}</span>
                                    <input type="text" class="form-control" value="{$blogDirectory|escape:'htmlall':'UTF-8'}" name="directory" id="directory" />
                                </div>
                            </div>
                        </div>
                        <div>
                            <div class="form-group">
                                <h4><strong>Homepage Recent Posts Widget</strong></h4>
                                <label for="recentPostsTitle">Heading title</label>
                                <input type="text" class="form-control" value="{$recentPostsTitle|escape:'htmlall':'UTF-8'}" name="recentPostsTitle" id="recentPostsTitle" />
                            </div>
                            <div class="form-group">
                                <label for="recentPostsCount">Number of posts to display</label>
                                <input type="text" class="form-control" value="{$recentPostsCount|escape:'htmlall':'UTF-8'}" name="recentPostsCount" id="recentPostsCount" />
                            </div>
                            <div class="form-group">
                                <label for="recentPostsCategoryFilter">Filter by category (example: seo-tips)</label>
                                <input type="text" class="form-control" value="{$recentPostsCategoryFilter|escape:'htmlall':'UTF-8'}" name="recentPostsCategoryFilter" id="recentPostsCategoryFilter" />
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="panel-footer">
                <button type="submit" value="1" name="saveSettings" class="btn btn-default">
                    <i class="process-icon-save"></i> Save
                </button>
                <a href="{$loginUrl|escape:'htmlall':'UTF-8'}" target="_blank" class="btn btn-primary pull-right">Manage Blog</a>
                <a href="/{$blogDirectory|escape:'htmlall':'UTF-8'}" target="_blank" class="btn btn-primary pull-right">View Blog</a>
            </div>
        </div>
    </form>
</div>
{/if}

<div id="app"></div>

<script src="{$pathVendor|escape:'htmlall':'UTF-8'}"></script>
<script src="{$pathApp|escape:'htmlall':'UTF-8'}"></script>
<script src="{$urlAccountsCdn|escape:'htmlall':'UTF-8'}" type="text/javascript"></script>

