{*
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
*}

{extends file="page.tpl"}

{block name='hook_extra' append}
    {if $blogData->customCss}
        <style>
            {$blogData->customCss|escape:'htmlall':'UTF-8'}
        </style>
    {/if}
    {if $blogData->rssUrl}
        <link href="{$blogData->rssUrl|escape:'htmlall':'UTF-8'}" rel="alternate" type="application/rss+xml" title="{$blogData->rssTitle|escape:'htmlall':'UTF-8'}">
    {/if}
{/block}

{block name='head_open_graph' append}
    {if $blogData->og_image}
        <meta property="og:image" content="{$blogData->og_image|escape:'htmlall':'UTF-8'}">
    {/if}
{/block}

{block name='head_microdata' append}
    {$blogData->schema_article|unescape: "html" nofilter}
{/block}

{block name="page_content"}
    {$blogData->content|unescape: "html" nofilter}
{/block}
