<?php
/**
 * Copyright © Lyra Network.
 * This file is part of EpayNC plugin for PrestaShop. See COPYING.md for license details.
 *
 * @author    Lyra Network (https://www.lyra.com/)
 * @copyright Lyra Network
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 */

class EpayncIframeModuleFrontController extends ModuleFrontController
{
    public $ssl = true;

    /**
     * @see FrontController::postProcess()
     */
    public function postProcess()
    {
        if (Configuration::get('EPAYNC_CART_MANAGEMENT') !== EpayncTools::KEEP_CART) {
            if ($this->context->cart->id) {
                $this->context->cookie->epayncCartId = (int) $this->context->cart->id;
            }

            if (isset($this->context->cookie->epayncCartId)) {
                $this->context->cookie->id_cart = $this->context->cookie->epayncCartId;
            }
        }

        $this->setTemplate(EpayncTools::getTemplatePath('iframe/loader.tpl'));
    }
}
