/**
 * Copyright © Lyra Network.
 * This file is part of EpayNC plugin for PrestaShop. See COPYING.md for license details.
 *
 * @author    Lyra Network (https://www.lyra.com/)
 * @copyright Lyra Network
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 */

/**
 * Misc JavaScript functions.
 */

function epayncAddMultiOption(first) {
    if (first) {
        $('#epaync_multi_options_btn').hide();
        $('#epaync_multi_options_table').show();
    }

    var timestamp = new Date().getTime();

    var rowTpl = $('#epaync_multi_row_option').html();
    rowTpl = rowTpl.replace(/EPAYNC_MULTI_KEY/g, '' + timestamp);

    $(rowTpl).insertBefore('#epaync_multi_option_add');
}

function epayncDeleteMultiOption(key) {
    $('#epaync_multi_option_' + key).remove();

    if ($('#epaync_multi_options_table tbody tr').length === 1) {
        $('#epaync_multi_options_btn').show();
        $('#epaync_multi_options_table').hide();
        $('#epaync_multi_options_table').append("<input type=\"hidden\" id=\"EPAYNC_MULTI_OPTIONS\" name=\"EPAYNC_MULTI_OPTIONS\" value=\"\">");
    }
}

function epayncAddOneyOption(first, suffix) {
    if (first) {
        $('#epaync_oney' + suffix + '_options_btn').hide();
        $('#epaync_oney' + suffix + '_options_table').show();
    }

    var timestamp = new Date().getTime();
    var key = suffix != '' ? /EPAYNC_ONEY34_KEY/g : /EPAYNC_ONEY_KEY/g;
    var rowTpl = $('#epaync_oney' + suffix + '_row_option').html();
    rowTpl = rowTpl.replace(key, '' + timestamp);

    $(rowTpl).insertBefore('#epaync_oney' + suffix + '_option_add');
}

function epayncDeleteOneyOption(key, suffix) {
    $('#epaync_oney' + suffix + '_option_' + key).remove();

    if ($('#epaync_oney' + suffix + '_options_table tbody tr').length === 1) {
        $('#epaync_oney' + suffix + '_options_btn').show();
        $('#epaync_oney' + suffix + '_options_table').hide();
        $('#epaync_oney' + suffix + '_options_table').append("<input type=\"hidden\" id=\"EPAYNC_ONEY" + suffix + "_OPTIONS\" name=\"EPAYNC_ONEY" + suffix + "_OPTIONS\" value=\"\">");
    }
}

function epayncAddFranfinanceOption(first) {
    if (first) {
        $('#epaync_ffin_options_btn').hide();
        $('#epaync_ffin_options_table').show();
    }

    var timestamp = new Date().getTime();
    var rowTpl = $('#epaync_ffin_row_option').html();
    rowTpl = rowTpl.replace(/EPAYNC_FFIN_KEY/g, '' + timestamp);

    $(rowTpl).insertBefore('#epaync_ffin_option_add');
}

function epayncDeleteFranfinanceOption(key) {
    $('#epaync_ffin_option_' + key).remove();

    if ($('#epaync_ffin_options_table tbody tr').length === 1) {
        $('#epaync_ffin_options_btn').show();
        $('#epaync_ffin_options_table').hide();
        $('#epaync_ffin_options_table').append("<input type=\"hidden\" id=\"EPAYNC_FFIN_OPTIONS\" name=\"EPAYNC_FFIN_OPTIONS\" value=\"\">");
    }
}

function epayncAdditionalOptionsToggle(legend) {
    var fieldset = $(legend).parent();

    $(legend).children('span').toggleClass('ui-icon-triangle-1-e ui-icon-triangle-1-s');
    fieldset.find('section').slideToggle();
}

function epayncCategoryTableVisibility() {
    var category = $('select#EPAYNC_COMMON_CATEGORY option:selected').val();

    if (category === 'CUSTOM_MAPPING') {
        $('.epaync_category_mapping').show();
        $('.epaync_category_mapping select').removeAttr('disabled');
    } else {
        $('.epaync_category_mapping').hide();
        $('.epaync_category_mapping select').attr('disabled', 'disabled');
    }
}

function epayncDeliveryTypeChanged(key) {
    var type = $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_type').val();

    if (type === 'RECLAIM_IN_SHOP') {
        $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_address').show();
        $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_zip').show();
        $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_city').show();
    } else {
        $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_address').val('');
        $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_zip').val('');
        $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_city').val('');

        $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_address').hide();
        $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_zip').hide();
        $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_city').hide();
    }

    var speed = $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_speed').val();
    if (speed === 'PRIORITY') {
        $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_delay').show();
    } else {
        $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_delay').hide();
    }
}

function epayncDeliverySpeedChanged(key) {
    var speed = $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_speed').val();
    var type = $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_type').val();

    if (speed === 'PRIORITY') {
        $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_delay').show();
    } else {
        $('#EPAYNC_ONEY_SHIP_OPTIONS_' + key + '_delay').hide();
    }
}

function epayncRedirectChanged() {
    var redirect = $('select#EPAYNC_REDIRECT_ENABLED option:selected').val();

    if (redirect === 'True') {
        $('#epaync_redirect_settings').show();
        $('#epaync_redirect_settings select, #epaync_redirect_settings input').removeAttr('disabled');
    } else {
        $('#epaync_redirect_settings').hide();
        $('#epaync_redirect_settings select, #epaync_redirect_settings input').attr('disabled', 'disabled');
    }
}

function epayncOneyEnableOptionsChanged() {
    var enable = $('select#EPAYNC_ONEY_ENABLE_OPTIONS option:selected').val();

    if (enable === 'True') {
        $('#epaync_oney_options_settings').show();
        $('#epaync_oney_options_settings select, #epaync_oney_options_settings input').removeAttr('disabled');
    } else {
        $('#epaync_oney_options_settings').hide();
        $('#epaync_oney_options_settings select, #epaync_oney_options_settings input').attr('disabled', 'disabled');
    }
}

function epayncFullcbEnableOptionsChanged() {
    var enable = $('select#EPAYNC_FULLCB_ENABLE_OPTS option:selected').val();

    if (enable === 'True') {
        $('#epaync_fullcb_options_settings').show();
        $('#epaync_fullcb_options_settings select, #epaync_fullcb_options_settings input').removeAttr('disabled');
    } else {
        $('#epaync_fullcb_options_settings').hide();
        $('#epaync_fullcb_options_settings select, #epaync_fullcb_options_settings input').attr('disabled', 'disabled');
    }
}

function epayncHideOtherLanguage(id, name) {
    $('.translatable-field').hide();
    $('.lang-' + id).css('display', 'inline');

    $('.translation-btn button span').text(name);

    var id_old_language = id_language;
    id_language = id;

    if (id_old_language !== id) {
        changeEmployeeLanguage();
    }
}

function epayncAddOtherPaymentMeansOption(first) {
    if (first) {
        $('#epaync_other_payment_means_options_btn').hide();
        $('#epaync_other_payment_means_options_table').show();
        $('#EPAYNC_OTHER_PAYMENT_MEANS').remove();
    }

    var timestamp = new Date().getTime();

    var rowTpl = $('#epaync_other_payment_means_row_option').html();
    rowTpl = rowTpl.replace(/EPAYNC_OTHER_PAYMENT_SCRIPT_MEANS_KEY/g, '' + timestamp);

    $(rowTpl).insertBefore('#epaync_other_payment_means_option_add');
}

function epayncDeleteOtherPaymentMeansOption(key) {
    $('#epaync_other_payment_means_option_' + key).remove();

    if ($('#epaync_other_payment_means_options_table tbody tr').length === 1) {
        $('#epaync_other_payment_means_options_btn').show();
        $('#epaync_other_payment_means_options_table').hide();
        $('#epaync_other_payment_means_options_table').append("<input type=\"hidden\" id=\"EPAYNC_OTHER_PAYMENT_MEANS\" name=\"EPAYNC_OTHER_PAYMENT_MEANS\" value=\"\">");
    }
}

function epayncAddExtraPaymentMeansOption(first) {
    if (first) {
        $('#epaync_extra_payment_means_options_btn').hide();
        $('#epaync_extra_payment_means_options_table').show();
        $('#EPAYNC_EXTRA_PAYMENT_MEANS').remove();
    }

    var timestamp = new Date().getTime();

    var rowTpl = $('#epaync_add_payment_means_row_option').html();
    rowTpl = rowTpl.replace(/EPAYNC_EXTRA_PAYMENT_MEANS_SCRIPT_KEY/g, '' + timestamp);

    $(rowTpl).insertBefore('#epaync_extra_payment_means_option_add');
}

function epayncDeleteExtraPaymentMeansOption(key) {
    $('#epaync_extra_payment_means_option_' + key).remove();

    if ($('#epaync_extra_payment_means_options_table tbody tr').length === 1) {
        $('#epaync_extra_payment_means_options_btn').show();
        $('#epaync_extra_payment_means_options_table').hide();
        $('#epaync_extra_payment_means_options_table').append("<input type=\"hidden\" id=\"EPAYNC_EXTRA_PAYMENT_MEANS\" name=\"EPAYNC_EXTRA_PAYMENT_MEANS\" value=\"\">");
    }
}

function epayncCountriesRestrictMenuDisplay(retrictCountriesPaymentId) {
    var countryRestrict = $('#' + retrictCountriesPaymentId).val();
    if (countryRestrict === '2') {
        $('#' + retrictCountriesPaymentId + '_MENU').show();
    } else {
        $('#' + retrictCountriesPaymentId + '_MENU').hide();
    }
}

function epayncOneClickMenuDisplay() {
    var oneClickPayment = $('#EPAYNC_STD_1_CLICK_PAYMENT').val();
    if (oneClickPayment == 'True') {
        $('#EPAYNC_STD_1_CLICK_MENU').show();
    } else {
        $('#EPAYNC_STD_1_CLICK_MENU').hide();
    }
}

function epayncDisplayMultiSelect(selectId) {
    $('#' + selectId).show();
    $('#' + selectId).focus();
    $('#LABEL_' + selectId).hide();
}

function epayncDisplayLabel(selectId, clickMessage) {
    $('#' + selectId).hide();
    $('#LABEL_' + selectId).show();
    $('#LABEL_' + selectId).text(epayncGetLabelText(selectId, clickMessage));
}

function epayncGetLabelText(selectId, clickMessage) {
    var select = document.getElementById(selectId);
    var labelText = '', option;

    for (var i = 0, len = select.options.length; i < len; i++) {
        option = select.options[i];

        if (option.selected) {
            labelText += option.text + ', ';
        }
    }

    labelText = labelText.substring(0, labelText.length - 2);
    if (!labelText) {
        labelText = clickMessage;
    }

    return labelText;
}

function epayncSepa1clickPaymentMenuDisplay(sepaMandateModeId) {
    var sepaMandateMode = $('#' + sepaMandateModeId).val();
    if (sepaMandateMode === 'REGISTER_PAY') {
        $('#EPAYNC_SEPA_1_CLICK_PAYMNT_MENU').show();
    } else {
        $('#EPAYNC_SEPA_1_CLICK_PAYMNT_MENU').hide();
    }
}