{**
 * Copyright © Lyra Network.
 * This file is part of EpayNC plugin for PrestaShop. See COPYING.md for license details.
 *
 * @author    Lyra Network (https://www.lyra.com/)
 * @copyright Lyra Network
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *}

<script type="text/javascript">
  $(function() {
    $('#accordion').accordion({
      active: false,
      collapsible: true,
      autoHeight: false,
      heightStyle: 'content',
      header: 'h4',
      animated: false
    });

    {if $epaync_plugin_features['support']}
      $('contact-support').on('sendmail', function(e){
        $.ajax({
          type: 'POST',
          url: "{$epaync_request_uri}",
          data: e.originalEvent.detail,
          success: function(res) {
            location.reload();
          },
          dataType: 'html'
        });
      });
    {/if}
  });
</script>

<script type="text/javascript">
  function epayncCardEntryChanged() {
    var cardDataMode = $('select#EPAYNC_STD_CARD_DATA_MODE option:selected').val();

    switch (cardDataMode) {
      case '4':
        if (! confirm('{l s='Warning, some payment means are not compatible with an integration by iframe. Please consult the documentation for more details.' mod='epaync'}')) {
          var oldCardDataMode = $('#EPAYNC_STD_CARD_DATA_MODE_OLD').val();
          $('select#EPAYNC_STD_CARD_DATA_MODE').val(oldCardDataMode).change()
        } else {
          $('#EPAYNC_REST_SETTINGS').hide();
          $('#EPAYNC_STD_CANCEL_IFRAME_MENU').show();
        }

        break;
      case '5':
      case '6':
        $('#EPAYNC_REST_SETTINGS').show();
        $('#EPAYNC_STD_CANCEL_IFRAME_MENU').hide();
        break;
      default:
        $('#EPAYNC_REST_SETTINGS').hide();
        $('#EPAYNC_STD_CANCEL_IFRAME_MENU').hide();
    }
  }
</script>

<form method="POST" action="{$epaync_request_uri|escape:'html':'UTF-8'}" class="defaultForm form-horizontal">
  <div style="width: 100%;">
    <fieldset>
      <legend>
        <img style="width: 20px; vertical-align: middle;" src="../modules/epaync/logo.png">EpayNC
      </legend>

      <div style="padding: 5px;">{l s='Developed by' mod='epaync'} <b><a href="https://www.lyra.com/" target="_blank">Lyra Network</a></b></div>
      <div style="padding: 5px;">{l s='Contact us' mod='epaync'} <span style="display: inline-table;"><b>{$epaync_formatted_support_email|unescape:'html':'UTF-8'}</b></span></div>
      <div style="padding: 5px;">{l s='Module version' mod='epaync'} <b>{if $smarty.const._PS_HOST_MODE_|defined}Cloud{/if}{$epaync_plugin_version|escape:'html':'UTF-8'}</b></div>
      <div style="padding: 5px;">{l s='Gateway version' mod='epaync'} <b>{$epaync_gateway_version|escape:'html':'UTF-8'}</b></div>

      {if !empty($epaync_doc_files)}
        <div style="padding: 5px;"><span style="color: red; font-weight: bold; text-transform: uppercase;">{l s='Click to view the module configuration documentation :' mod='epaync'}</span>
        {foreach from=$epaync_doc_files key="file" item="lang"}
          <a style="margin-left: 10px; font-weight: bold; text-transform: uppercase;" href="../modules/epaync/installation_doc/{$file|escape:'html':'UTF-8'}" target="_blank">{$lang|escape:'html':'UTF-8'}</a>
        {/foreach}
        </div>
      {/if}

      {if $epaync_plugin_features['support']}
        <div style="padding: 5px;"><contact-support
          shop-id="{$EPAYNC_SITE_ID|escape:'html':'UTF-8'}"
          context-mode="{$EPAYNC_MODE|escape:'html':'UTF-8'}"
          sign-algo="{$EPAYNC_SIGN_ALGO|escape:'html':'UTF-8'}"
          contrib="{$epaync_contrib|escape:'html':'UTF-8'}"
          integration-mode="{$epaync_card_data_entry_modes[$EPAYNC_STD_CARD_DATA_MODE]|escape:'html':'UTF-8'}"
          plugins="{$epaync_installed_modules|escape:'html':'UTF-8'}"
          title=""
          first-name="{$epaync_employee->firstname|escape:'html':'UTF-8'}"
          last-name="{$epaync_employee->lastname|escape:'html':'UTF-8'}"
          from-email="{$epaync_employee->email|escape:'html':'UTF-8'}"
          to-email="{$epaync_support_email|escape:'html':'UTF-8'}"
          cc-emails=""
          phone-number=""
          language="{$prestashop_lang.iso_code|escape:'html':'UTF-8'}">
        </contact-support></div>
      {/if}
    </fieldset>
  </div>

  <br /><br />

  <div id="accordion" style="width: 100%; float: none;">
    <h4 style="font-weight: bold; margin-bottom: 0; overflow: hidden; line-height: unset !important;">
      <a href="#">{l s='GENERAL CONFIGURATION' mod='epaync'}</a>
    </h4>
    <div>
      <fieldset>
        <legend>{l s='BASE SETTINGS' mod='epaync'}</legend>

        <label for="EPAYNC_ENABLE_LOGS">{l s='Logs' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_ENABLE_LOGS" name="EPAYNC_ENABLE_LOGS">
            {foreach from=$epaync_enable_disable_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_ENABLE_LOGS === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <p>{l s='Enable / disbale module logs' mod='epaync'}</p>
        </div>
      </fieldset>
      <div class="clear">&nbsp;</div>

      <fieldset>
        <legend>{l s='PAYMENT GATEWAY ACCESS' mod='epaync'}</legend>

        <label for="EPAYNC_SITE_ID">{l s='Site ID' mod='epaync'}</label>
        <div class="margin-form">
          <input type="text" id="EPAYNC_SITE_ID" name="EPAYNC_SITE_ID" value="{$EPAYNC_SITE_ID|escape:'html':'UTF-8'}" autocomplete="off">
          <p>{l s='The identifier provided by your bank.' mod='epaync'}</p>
        </div>

        {if !$epaync_plugin_features['qualif']}
          <label for="EPAYNC_KEY_TEST">{l s='Key in test mode' mod='epaync'}</label>
          <div class="margin-form">
            <input type="text" id="EPAYNC_KEY_TEST" name="EPAYNC_KEY_TEST" value="{$EPAYNC_KEY_TEST|escape:'html':'UTF-8'}" autocomplete="off">
            <p>{l s='Key provided by your bank for test mode (available in your store Back Office).' mod='epaync'}</p>
          </div>
        {/if}

        <label for="EPAYNC_KEY_PROD">{l s='Key in production mode' mod='epaync'}</label>
        <div class="margin-form">
          <input type="text" id="EPAYNC_KEY_PROD" name="EPAYNC_KEY_PROD" value="{$EPAYNC_KEY_PROD|escape:'html':'UTF-8'}" autocomplete="off">
          <p>{l s='Key provided by your bank (available in your store Back Office after enabling production mode).' mod='epaync'}</p>
        </div>

        <label for="EPAYNC_MODE">{l s='Mode' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_MODE" name="EPAYNC_MODE" {if $epaync_plugin_features['qualif']} disabled="disabled"{/if}>
            {foreach from=$epaync_mode_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_MODE === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <p>{l s='The context mode of this module.' mod='epaync'}</p>
        </div>

        <label for="EPAYNC_SIGN_ALGO">{l s='Signature algorithm' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_SIGN_ALGO" name="EPAYNC_SIGN_ALGO">
            <option value="SHA-1"{if $EPAYNC_SIGN_ALGO === 'SHA-1'} selected="selected"{/if}>SHA-1</option>
            <option value="SHA-256"{if $EPAYNC_SIGN_ALGO === 'SHA-256'} selected="selected"{/if}>HMAC-SHA-256</option>
          </select>
          <p>
            {l s='Algorithm used to compute the payment form signature. Selected algorithm must be the same as one configured in your store Back Office.' mod='epaync'}<br />
            {if !$epaync_plugin_features['shatwo']}
              <b>{l s='The HMAC-SHA-256 algorithm should not be activated if it is not yet available in your store Back Office, the feature will be available soon.' mod='epaync'}</b>
            {/if}
          </p>
        </div>

        <label>{l s='Instant Payment Notification URL' mod='epaync'}</label>
        <div class="margin-form">
          <span style="font-weight: bold;">{$EPAYNC_NOTIFY_URL|escape:'html':'UTF-8'}</span><br />
          <p>
            <img src="{$smarty.const._MODULE_DIR_|escape:'html':'UTF-8'}epaync/views/img/warn.png">
            <span style="color: red; display: inline-block;">
              {l s='URL to copy into your bank Back Office > Settings > Notification rules.' mod='epaync'}<br />
              {l s='In multistore mode, notification URL is the same for all the stores.' mod='epaync'}
            </span>
          </p>
        </div>

        <label for="EPAYNC_PLATFORM_URL">{l s='Payment page URL' mod='epaync'}</label>
        <div class="margin-form">
          <input type="text" id="EPAYNC_PLATFORM_URL" name="EPAYNC_PLATFORM_URL" value="{$EPAYNC_PLATFORM_URL|escape:'html':'UTF-8'}" style="width: 470px;">
          <p>{l s='Link to the payment page.' mod='epaync'}</p>
        </div>
      </fieldset>
      <div class="clear">&nbsp;</div>

      <fieldset>
        <legend onclick="javascript: epayncAdditionalOptionsToggle(this);" style="cursor: pointer;">
          <span class="ui-icon ui-icon-triangle-1-e" style="display: inline-block; vertical-align: middle;"></span>
          {l s='REST API KEYS' mod='epaync'}
        </legend>

        <p style="font-size: .85em; color: #7F7F7F;">
         {l s='REST API keys are available in your store Back Office (menu: Settings > Shops > REST API keys).' mod='epaync'}
        </p>

        <section style="display: none; padding-top: 15px;">
          <p style="font-size: .85em; color: #7F7F7F;">
           {l s='Configure this section if you are using order operations from Prestashop Back Office or if you are using embedded payment fields or popin modes.' mod='epaync'}
          </p>
          <label for="EPAYNC_PRIVKEY_TEST">{l s='Test password' mod='epaync'}</label>
          <div class="margin-form">
            <input type="password" id="EPAYNC_PRIVKEY_TEST" name="EPAYNC_PRIVKEY_TEST" value="{$EPAYNC_PRIVKEY_TEST|escape:'html':'UTF-8'}" style="width: 470px;" autocomplete="off" />
          </div>
          <p></p>

          <label for="EPAYNC_PRIVKEY_PROD">{l s='Production password' mod='epaync'}</label>
          <div style="border-bottom: 5px;" class="margin-form">
            <input type="password" id="EPAYNC_PRIVKEY_PROD" name="EPAYNC_PRIVKEY_PROD" value="{$EPAYNC_PRIVKEY_PROD|escape:'html':'UTF-8'}" style="width: 470px;" autocomplete="off">
          </div>
          <p></p>

          <label for="EPAYNC_REST_SERVER_URL">{l s='REST API server URL' mod='epaync'}</label>
          <div class="margin-form">
            <input type="text" id="EPAYNC_REST_SERVER_URL" name="EPAYNC_REST_SERVER_URL" value="{$EPAYNC_REST_SERVER_URL|escape:'html':'UTF-8'}" style="width: 470px;" autocomplete="off">
          </div>
          <p></p>

          <p style="font-size: .85em; color: #7F7F7F;">
           {l s='Configure this section only if you are using embedded payment fields or popin modes.' mod='epaync'}
          </p>
          <p></p>

          <label for="EPAYNC_PUBKEY_TEST">{l s='Public test key' mod='epaync'}</label>
          <div class="margin-form">
            <input type="text" id="EPAYNC_PUBKEY_TEST" name="EPAYNC_PUBKEY_TEST" value="{$EPAYNC_PUBKEY_TEST|escape:'html':'UTF-8'}" style="width: 470px;" autocomplete="off">
          </div>
          <p></p>

          <label for="EPAYNC_PUBKEY_PROD">{l s='Public production key' mod='epaync'}</label>
          <div class="margin-form">
            <input type="text" id="EPAYNC_PUBKEY_PROD" name="EPAYNC_PUBKEY_PROD" value="{$EPAYNC_PUBKEY_PROD|escape:'html':'UTF-8'}" style="width: 470px;" autocomplete="off">
          </div>
          <p></p>

          <label for="EPAYNC_RETKEY_TEST">{l s='HMAC-SHA-256 test key' mod='epaync'}</label>
          <div class="margin-form">
            <input type="password" id="EPAYNC_RETKEY_TEST" name="EPAYNC_RETKEY_TEST" value="{$EPAYNC_RETKEY_TEST|escape:'html':'UTF-8'}" style="width: 470px;" autocomplete="off">
          </div>
          <p></p>

          <label for="EPAYNC_RETKEY_PROD">{l s='HMAC-SHA-256 production key' mod='epaync'}</label>
          <div class="margin-form">
            <input type="password" id="EPAYNC_RETKEY_PROD" name="EPAYNC_RETKEY_PROD" value="{$EPAYNC_RETKEY_PROD|escape:'html':'UTF-8'}" style="width: 470px;" autocomplete="off">
          </div>
          <p></p>

          <label>{l s='API REST Notification URL' mod='epaync'}</label>
          <div class="margin-form">
            {$EPAYNC_REST_NOTIFY_URL|escape:'html':'UTF-8'}<br />
            <p>
              <img src="{$smarty.const._MODULE_DIR_|escape:'html':'UTF-8'}epaync/views/img/warn.png">
              <span style="color: red; display: inline-block;">
                {l s='URL to copy into your bank Back Office > Settings > Notification rules.' mod='epaync'}<br />
                {l s='In multistore mode, notification URL is the same for all the stores.' mod='epaync'}
              </span>
            </p>
          </div>

          <label for="EPAYNC_REST_JS_CLIENT_URL">{l s='JavaScript client URL' mod='epaync'}</label>
          <div class="margin-form">
            <input type="text" id="EPAYNC_REST_JS_CLIENT_URL" name="EPAYNC_REST_JS_CLIENT_URL" value="{$EPAYNC_REST_JS_CLIENT_URL|escape:'html':'UTF-8'}" style="width: 470px;" autocomplete="off">
          </div>
        </section>
      </fieldset>
      <div class="clear">&nbsp;</div>

      <fieldset>
        <legend>{l s='PAYMENT PAGE' mod='epaync'}</legend>

        <label for="EPAYNC_DEFAULT_LANGUAGE">{l s='Default language' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_DEFAULT_LANGUAGE" name="EPAYNC_DEFAULT_LANGUAGE">
            {foreach from=$epaync_language_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_DEFAULT_LANGUAGE === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <p>{l s='Default language on the payment page.' mod='epaync'}</p>
        </div>

        <label for="EPAYNC_AVAILABLE_LANGUAGES">{l s='Available languages' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_AVAILABLE_LANGUAGES" name="EPAYNC_AVAILABLE_LANGUAGES[]" multiple="multiple" size="8">
            {foreach from=$epaync_language_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if in_array($key, $EPAYNC_AVAILABLE_LANGUAGES)} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <p>{l s='Languages available on the payment page. If you do not select any, all the supported languages will be available.' mod='epaync'}</p>
        </div>

        <label for="EPAYNC_DELAY">{l s='Capture delay' mod='epaync'}</label>
        <div class="margin-form">
          <input type="text" id="EPAYNC_DELAY" name="EPAYNC_DELAY" value="{$EPAYNC_DELAY|escape:'html':'UTF-8'}">
          <p>{l s='The number of days before the bank capture (adjustable in your store Back Office).' mod='epaync'}</p>
        </div>

        <label for="EPAYNC_VALIDATION_MODE">{l s='Validation mode' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_VALIDATION_MODE" name="EPAYNC_VALIDATION_MODE">
            {foreach from=$epaync_validation_mode_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_VALIDATION_MODE === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <p>{l s='If manual is selected, you will have to confirm payments manually in your bank Back Office.' mod='epaync'}</p>
        </div>
      </fieldset>
      <div class="clear">&nbsp;</div>

      <fieldset>
        <legend>{l s='PAYMENT PAGE CUSTOMIZE' mod='epaync'}</legend>

        <label>{l s='Theme configuration' mod='epaync'}</label>
        <div class="margin-form">
          {include file="./input_text_lang.tpl"
              languages=$prestashop_languages
              current_lang=$prestashop_lang
              input_name="EPAYNC_THEME_CONFIG"
              input_value=$EPAYNC_THEME_CONFIG
              style="width: 470px;"
           }
          <p>{l s='The theme configuration to customize the payment page.' mod='epaync'}</p>
        </div>

        <label for="EPAYNC_SHOP_NAME">{l s='Shop name' mod='epaync'}</label>
        <div class="margin-form">
          <input type="text" id="EPAYNC_SHOP_NAME" name="EPAYNC_SHOP_NAME" value="{$EPAYNC_SHOP_NAME|escape:'html':'UTF-8'}">
          <p>{l s='Shop name to display on the payment page. Leave blank to use gateway configuration.' mod='epaync'}</p>
        </div>

        <label for="EPAYNC_SHOP_URL">{l s='Shop URL' mod='epaync'}</label>
        <div class="margin-form">
          <input type="text" id="EPAYNC_SHOP_URL" name="EPAYNC_SHOP_URL" value="{$EPAYNC_SHOP_URL|escape:'html':'UTF-8'}" style="width: 470px;">
          <p>{l s='Shop URL to display on the payment page. Leave blank to use gateway configuration.' mod='epaync'}</p>
        </div>
      </fieldset>
      <div class="clear">&nbsp;</div>

      <fieldset>
        <legend>{l s='CUSTOM 3DS' mod='epaync'}</legend>

        <label for="EPAYNC_3DS_MIN_AMOUNT">{l s='Manage 3DS by customer group' mod='epaync'}</label>
        <div class="margin-form">
          {include file="./table_amount_group.tpl"
            groups=$prestashop_groups
            input_name="EPAYNC_3DS_MIN_AMOUNT"
            input_value=$EPAYNC_3DS_MIN_AMOUNT
            min_only=true
          }
          <p>{l s='Amount by customer group below which customer could be exempt from strong authentication. Needs subscription to « Selective 3DS1 » or « Frictionless 3DS2 » options. For more information, refer to the module documentation.' mod='epaync'}</p>
        </div>
      </fieldset>
      <div class="clear">&nbsp;</div>

      <fieldset>
        <legend>{l s='RETURN TO SHOP' mod='epaync'}</legend>

        <label for="EPAYNC_REDIRECT_ENABLED">{l s='Automatic redirection' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_REDIRECT_ENABLED" name="EPAYNC_REDIRECT_ENABLED" onchange="javascript: epayncRedirectChanged();">
            {foreach from=$epaync_enable_disable_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_REDIRECT_ENABLED === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <p>{l s='If enabled, the buyer is automatically redirected to your site at the end of the payment.' mod='epaync'}</p>
        </div>

        <section id="epaync_redirect_settings">
          <label for="EPAYNC_REDIRECT_SUCCESS_T">{l s='Redirection timeout on success' mod='epaync'}</label>
          <div class="margin-form">
            <input type="text" id="EPAYNC_REDIRECT_SUCCESS_T" name="EPAYNC_REDIRECT_SUCCESS_T" value="{$EPAYNC_REDIRECT_SUCCESS_T|escape:'html':'UTF-8'}">
            <p>{l s='Time in seconds (0-300) before the buyer is automatically redirected to your website after a successful payment.' mod='epaync'}</p>
          </div>

          <label>{l s='Redirection message on success' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./input_text_lang.tpl"
              languages=$prestashop_languages
              current_lang=$prestashop_lang
              input_name="EPAYNC_REDIRECT_SUCCESS_M"
              input_value=$EPAYNC_REDIRECT_SUCCESS_M
              style="width: 470px;"
            }
            <p>{l s='Message displayed on the payment page prior to redirection after a successful payment.' mod='epaync'}</p>
          </div>

          <label for="EPAYNC_REDIRECT_ERROR_T">{l s='Redirection timeout on failure' mod='epaync'}</label>
          <div class="margin-form">
            <input type="text" id="EPAYNC_REDIRECT_ERROR_T" name="EPAYNC_REDIRECT_ERROR_T" value="{$EPAYNC_REDIRECT_ERROR_T|escape:'html':'UTF-8'}">
            <p>{l s='Time in seconds (0-300) before the buyer is automatically redirected to your website after a declined payment.' mod='epaync'}</p>
          </div>

          <label>{l s='Redirection message on failure' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./input_text_lang.tpl"
              languages=$prestashop_languages
              current_lang=$prestashop_lang
              input_name="EPAYNC_REDIRECT_ERROR_M"
              input_value=$EPAYNC_REDIRECT_ERROR_M
              style="width: 470px;"
            }
            <p>{l s='Message displayed on the payment page prior to redirection after a declined payment.' mod='epaync'}</p>
          </div>
        </section>

        <script type="text/javascript">
          epayncRedirectChanged();
        </script>

        <label for="EPAYNC_RETURN_MODE">{l s='Return mode' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_RETURN_MODE" name="EPAYNC_RETURN_MODE">
            <option value="GET"{if $EPAYNC_RETURN_MODE === 'GET'} selected="selected"{/if}>GET</option>
            <option value="POST"{if $EPAYNC_RETURN_MODE === 'POST'} selected="selected"{/if}>POST</option>
          </select>
          <p>{l s='Method that will be used for transmitting the payment result from the payment page to your shop.' mod='epaync'}</p>
        </div>

        <label for="EPAYNC_FAILURE_MANAGEMENT">{l s='Payment failed management' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_FAILURE_MANAGEMENT" name="EPAYNC_FAILURE_MANAGEMENT">
            {foreach from=$epaync_failure_management_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_FAILURE_MANAGEMENT === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <p>{l s='How to manage the buyer return to shop when the payment is failed.' mod='epaync'}</p>
        </div>

        <label for="EPAYNC_CART_MANAGEMENT">{l s='Cart management' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_CART_MANAGEMENT" name="EPAYNC_CART_MANAGEMENT">
            {foreach from=$epaync_cart_management_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_CART_MANAGEMENT === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <p>{l s='We recommend to choose the option « Empty cart » in order to avoid amount inconsistencies. In case of return back from the browser button the cart will be emptied. However in case of cancelled or refused payment, the cart will be recovered. If you do not want to have this behavior but the default PrestaShop one which is to keep the cart, choose the second option.' mod='epaync'}</p>
        </div>
      </fieldset>
      <div class="clear">&nbsp;</div>

      <fieldset>
        <legend onclick="javascript: epayncAdditionalOptionsToggle(this);" style="cursor: pointer;">
          <span class="ui-icon ui-icon-triangle-1-e" style="display: inline-block; vertical-align: middle;"></span>
          {l s='ADDITIONAL OPTIONS' mod='epaync'}
        </legend>
        <p style="font-size: .85em; color: #7F7F7F;">{l s='Configure this section if you use advanced risk assessment module or if you have a Oney 3x/4x contract.' mod='epaync'}</p>

        <section style="display: none; padding-top: 15px;">
          <label for="EPAYNC_SEND_CART_DETAIL">{l s='Send shopping cart details' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_SEND_CART_DETAIL" name="EPAYNC_SEND_CART_DETAIL">
              {foreach from=$epaync_enable_disable_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_SEND_CART_DETAIL === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='If you disable this option, the shopping cart details will not be sent to the gateway. Attention, in some cases, this option has to be enabled. For more information, refer to the module documentation.' mod='epaync'}</p>
          </div>

          <label for="EPAYNC_COMMON_CATEGORY">{l s='Category mapping' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_COMMON_CATEGORY" name="EPAYNC_COMMON_CATEGORY" style="width: 220px;" onchange="javascript: epayncCategoryTableVisibility();">
              <option value="CUSTOM_MAPPING"{if $EPAYNC_COMMON_CATEGORY === 'CUSTOM_MAPPING'} selected="selected"{/if}>{l s='(Use category mapping below)' mod='epaync'}</option>
              {foreach from=$epaync_category_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_COMMON_CATEGORY === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Use the same category for all products.' mod='epaync'}</p>

            <table cellpadding="10" cellspacing="0" class="table epaync_category_mapping" style="margin-top: 15px;{if $EPAYNC_COMMON_CATEGORY != 'CUSTOM_MAPPING'} display: none;{/if}">
            <thead>
              <tr>
                <th>{l s='Product category' mod='epaync'}</th>
                <th>{l s='Bank product category' mod='epaync'}</th>
              </tr>
            </thead>
            <tbody>
              {foreach from=$prestashop_categories item="category"}
                {if $category.id_parent === 0}
                  {continue}
                {/if}

                {assign var="category_id" value=$category.id_category}

                {if isset($EPAYNC_CATEGORY_MAPPING[$category_id])}
                  {assign var="exists" value=true}
                {else}
                  {assign var="exists" value=false}
                {/if}

                {if $exists}
                  {assign var="epaync_category" value=$EPAYNC_CATEGORY_MAPPING[$category_id]}
                {else}
                  {assign var="epaync_category" value="FOOD_AND_GROCERY"}
                {/if}

                <tr id="epaync_category_mapping_{$category_id|escape:'html':'UTF-8'}">
                  <td>{$category.name|escape:'html':'UTF-8'}{if $exists === false}<span style="color: red;">*</span>{/if}</td>
                  <td>
                    <select id="EPAYNC_CATEGORY_MAPPING_{$category_id|escape:'html':'UTF-8'}" name="EPAYNC_CATEGORY_MAPPING[{$category_id|escape:'html':'UTF-8'}]"
                        style="width: 220px;"{if $EPAYNC_COMMON_CATEGORY != 'CUSTOM_MAPPING'} disabled="disabled"{/if}>
                      {foreach from=$epaync_category_options key="key" item="option"}
                        <option value="{$key|escape:'html':'UTF-8'}"{if $epaync_category === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                      {/foreach}
                    </select>
                  </td>
                </tr>
              {/foreach}
            </tbody>
            </table>
            <p class="epaync_category_mapping"{if $EPAYNC_COMMON_CATEGORY != 'CUSTOM_MAPPING'} style="display: none;"{/if}>{l s='Match each product category with a bank product category.' mod='epaync'} <b>{l s='Entries marked with * are newly added and must be configured.' mod='epaync'}</b></p>
          </div>

          <label for="EPAYNC_SEND_SHIP_DATA">{l s='Always send advanced shipping data' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_SEND_SHIP_DATA" name="EPAYNC_SEND_SHIP_DATA">
              {foreach from=$epaync_yes_no_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_SEND_SHIP_DATA === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Select « Yes » to send advanced shipping data for all payments (carrier name, delivery type and delivery rapidity).' mod='epaync'}</p>
          </div>

          <label>{l s='Shipping options' mod='epaync'}</label>
          <div class="margin-form">
            <table class="table" cellpadding="10" cellspacing="0">
            <thead>
              <tr>
                <th>{l s='Method title' mod='epaync'}</th>
                <th>{l s='Name' mod='epaync'}</th>
                <th>{l s='Type' mod='epaync'}</th>
                <th>{l s='Rapidity' mod='epaync'}</th>
                <th>{l s='Delay' mod='epaync'}</th>
                <th style="width: 270px;" colspan="3">{l s='Address' mod='epaync'}</th>
              </tr>
            </thead>
            <tbody>
              {foreach from=$prestashop_carriers item="carrier"}
                {assign var="carrier_id" value=$carrier.id_carrier}

                {if isset($EPAYNC_ONEY_SHIP_OPTIONS[$carrier_id])}
                  {assign var="exists" value=true}
                {else}
                  {assign var="exists" value=false}
                {/if}

                {if $exists}
                  {assign var="ship_option" value=$EPAYNC_ONEY_SHIP_OPTIONS[$carrier_id]}
                {/if}

                <tr>
                  <td>{$carrier.name|escape:'html':'UTF-8'}{if $exists === false}<span style="color: red;">*</span>{/if}</td>
                  <td>
                    <input id="EPAYNC_ONEY_SHIP_OPTIONS_{$carrier_id|escape:'html':'UTF-8'}_label"
                        name="EPAYNC_ONEY_SHIP_OPTIONS[{$carrier_id|escape:'html':'UTF-8'}][label]"
                        value="{if isset($ship_option)}{$ship_option.label|escape:'html':'UTF-8'}{else}{$carrier.name|regex_replace:"#[^A-Z0-9ÁÀÂÄÉÈÊËÍÌÎÏÓÒÔÖÚÙÛÜÇ /'-]#ui":" "|substr:0:55}{/if}"
                        type="text">
                  </td>
                  <td>
                    <select id="EPAYNC_ONEY_SHIP_OPTIONS_{$carrier_id|escape:'html':'UTF-8'}_type" name="EPAYNC_ONEY_SHIP_OPTIONS[{$carrier_id|escape:'html':'UTF-8'}][type]" onchange="javascript: epayncDeliveryTypeChanged({$carrier_id|escape:'html':'UTF-8'});" style="width: 150px;">
                      {foreach from=$epaync_delivery_type_options key="key" item="option"}
                        <option value="{$key|escape:'html':'UTF-8'}"{if (isset($ship_option) && $ship_option.type === $key) || ('PACKAGE_DELIVERY_COMPANY' === $key)} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                      {/foreach}
                    </select>
                  </td>
                  <td>
                    <select id="EPAYNC_ONEY_SHIP_OPTIONS_{$carrier_id|escape:'html':'UTF-8'}_speed" name="EPAYNC_ONEY_SHIP_OPTIONS[{$carrier_id|escape:'html':'UTF-8'}][speed]" onchange="javascript: epayncDeliverySpeedChanged({$carrier_id|escape:'html':'UTF-8'});">
                      {foreach from=$epaync_delivery_speed_options key="key" item="option"}
                        <option value="{$key|escape:'html':'UTF-8'}"{if (isset($ship_option) && $ship_option.speed === $key) || ('STANDARD' === $key)} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                      {/foreach}
                    </select>
                  </td>
                  <td>
                    <select
                        id="EPAYNC_ONEY_SHIP_OPTIONS_{$carrier_id|escape:'html':'UTF-8'}_delay"
                        name="EPAYNC_ONEY_SHIP_OPTIONS[{$carrier_id|escape:'html':'UTF-8'}][delay]"
                        style="{if !isset($ship_option) || ($ship_option.type != 'RECLAIM_IN_SHOP') || ($ship_option.speed != 'PRIORITY')} display: none;{/if}">
                      {foreach from=$epaync_delivery_delay_options key="key" item="option"}
                        <option value="{$key|escape:'html':'UTF-8'}"{if (isset($ship_option) && isset($ship_option.delay) && ($ship_option.delay === $key)) || 'INFERIOR_EQUALS' === $key} selected="selected"{/if}>{$option|escape:'quotes':'UTF-8'}</option>
                      {/foreach}
                    </select>
                  </td>
                  <td>
                    <input
                        id="EPAYNC_ONEY_SHIP_OPTIONS_{$carrier_id|escape:'html':'UTF-8'}_address"
                        name="EPAYNC_ONEY_SHIP_OPTIONS[{$carrier_id|escape:'html':'UTF-8'}][address]"
                        placeholder="{l s='Address' mod='epaync'}"
                        value="{if isset($ship_option)}{$ship_option.address|escape:'html':'UTF-8'}{/if}"
                        style="width: 160px;{if !isset($ship_option) || $ship_option.type != 'RECLAIM_IN_SHOP'} display: none;{/if}"
                        type="text">
                  </td>
                  <td>
                    <input
                        id="EPAYNC_ONEY_SHIP_OPTIONS_{$carrier_id|escape:'html':'UTF-8'}_zip"
                        name="EPAYNC_ONEY_SHIP_OPTIONS[{$carrier_id|escape:'html':'UTF-8'}][zip]"
                        placeholder="{l s='Zip code' mod='epaync'}"
                        value="{if isset($ship_option)}{$ship_option.zip|escape:'html':'UTF-8'}{/if}"
                        style="width: 50px;{if !isset($ship_option) || $ship_option.type != 'RECLAIM_IN_SHOP'} display: none;{/if}"
                        type="text">
                  </td>
                  <td>
                    <input
                        id="EPAYNC_ONEY_SHIP_OPTIONS_{$carrier_id|escape:'html':'UTF-8'}_city"
                        name="EPAYNC_ONEY_SHIP_OPTIONS[{$carrier_id|escape:'html':'UTF-8'}][city]"
                        placeholder="{l s='City' mod='epaync'}"
                        value="{if isset($ship_option)}{$ship_option.city|escape:'html':'UTF-8'}{/if}"
                        style="width: 160px;{if !isset($ship_option) || $ship_option.type != 'RECLAIM_IN_SHOP'} display: none;{/if}"
                        type="text">
                  </td>
                </tr>
              {/foreach}
            </tbody>
            </table>
            <p>
              {l s='Define the information about all shipping methods.' mod='epaync'}<br />
              <b>{l s='Name' mod='epaync'} : </b>{l s='The label of the shipping method (use 55 alphanumeric characters, accentuated characters and these special characters: space, slash, hyphen, apostrophe).' mod='epaync'}<br />
              <b>{l s='Type' mod='epaync'} : </b>{l s='The delivery type of shipping method.' mod='epaync'}<br />
              <b>{l s='Rapidity' mod='epaync'} : </b>{l s='Select the delivery rapidity.' mod='epaync'}<br />
              <b>{l s='Delay' mod='epaync'} : </b>{l s='Select the delivery delay if speed is « Priority ».' mod='epaync'}<br />
              <b>{l s='Address' mod='epaync'} : </b>{l s='Enter address if it is a reclaim in shop.' mod='epaync'}<br />
              <b>{l s='Entries marked with * are newly added and must be configured.' mod='epaync'}</b>
            </p>
          </div>
        </section>
      </fieldset>
      <div class="clear">&nbsp;</div>
    </div>

    <h4 style="font-weight: bold; margin-bottom: 0; overflow: hidden; line-height: unset !important;">
      <a href="#">{l s='STANDARD PAYMENT' mod='epaync'}</a>
    </h4>
    <div>
      <fieldset>
        <legend>{l s='MODULE OPTIONS' mod='epaync'}</legend>

       <label for="EPAYNC_STD_ENABLED">{l s='Activation' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_STD_ENABLED" name="EPAYNC_STD_ENABLED">
            {foreach from=$epaync_enable_disable_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_STD_ENABLED === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <p>{l s='Enables / disables this payment method.' mod='epaync'}</p>
        </div>

        <label>{l s='Payment method title' mod='epaync'}</label>
        <div class="margin-form">
          {include file="./input_text_lang.tpl"
            languages=$prestashop_languages
            current_lang=$prestashop_lang
            input_name="EPAYNC_STD_TITLE"
            input_value=$EPAYNC_STD_TITLE
            style="width: 330px;"
          }
          <p>{l s='Method title to display on payment means page.' mod='epaync'}</p>
        </div>
      </fieldset>
      <div class="clear">&nbsp;</div>

      <fieldset>
        <legend>{l s='RESTRICTIONS' mod='epaync'}</legend>

        <label for="EPAYNC_STD_COUNTRY">{l s='Restrict to some countries' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_STD_COUNTRY" name="EPAYNC_STD_COUNTRY" onchange="javascript: epayncCountriesRestrictMenuDisplay('EPAYNC_STD_COUNTRY')">
            {foreach from=$epaync_countries_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_STD_COUNTRY === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <p>{l s='Buyer\'s billing countries in which this payment method is available.' mod='epaync'}</p>
        </div>

        <div id="EPAYNC_STD_COUNTRY_MENU" {if $EPAYNC_STD_COUNTRY === '1'} style="display: none;"{/if}>
          <label for="EPAYNC_STD_COUNTRY_LST">{l s='Authorized countries' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_STD_COUNTRY_LST" name="EPAYNC_STD_COUNTRY_LST[]" multiple="multiple" size="7">
              {foreach from=$epaync_countries_list['ps_countries'] key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if in_array($key, $EPAYNC_STD_COUNTRY_LST)} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
          </div>
        </div>

        <label>{l s='Customer group amount restriction' mod='epaync'}</label>
        <div class="margin-form">
          {include file="./table_amount_group.tpl"
            groups=$prestashop_groups
            input_name="EPAYNC_STD_AMOUNTS"
            input_value=$EPAYNC_STD_AMOUNTS
          }
          <p>{l s='Define amount restriction for each customer group.' mod='epaync'}</p>
        </div>
      </fieldset>
      <div class="clear">&nbsp;</div>

      <fieldset>
        <legend>{l s='PAYMENT PAGE' mod='epaync'}</legend>

        <label for="EPAYNC_STD_DELAY">{l s='Capture delay' mod='epaync'}</label>
        <div class="margin-form">
          <input id="EPAYNC_STD_DELAY" name="EPAYNC_STD_DELAY" value="{$EPAYNC_STD_DELAY|escape:'html':'UTF-8'}" type="text">
          <p>{l s='The number of days before the bank capture. Enter value only if different from « Base settings ».' mod='epaync'}</p>
        </div>

        <label for="EPAYNC_STD_VALIDATION">{l s='Validation mode' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_STD_VALIDATION" name="EPAYNC_STD_VALIDATION">
            <option value="-1"{if $EPAYNC_STD_VALIDATION === '-1'} selected="selected"{/if}>{l s='Base settings configuration' mod='epaync'}</option>
            {foreach from=$epaync_validation_mode_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_STD_VALIDATION === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <p>{l s='If manual is selected, you will have to confirm payments manually in your bank Back Office.' mod='epaync'}</p>
        </div>

        <label for="EPAYNC_STD_PAYMENT_CARDS">{l s='Card Types' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_STD_PAYMENT_CARDS" name="EPAYNC_STD_PAYMENT_CARDS[]" multiple="multiple" size="7">
            {foreach from=$epaync_payment_cards_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if in_array($key, $EPAYNC_STD_PAYMENT_CARDS)} selected="selected"{/if}>{if $key !== ""} {$key|escape:'html':'UTF-8'} - {/if}{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <p>{l s='The card type(s) that can be used for the payment. Select none to use gateway configuration.' mod='epaync'}</p>
        </div>

        {if $epaync_plugin_features['oney']}
          <label for="EPAYNC_STD_PROPOSE_ONEY">{l s='Propose FacilyPay Oney' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_STD_PROPOSE_ONEY" name="EPAYNC_STD_PROPOSE_ONEY">
              {foreach from=$epaync_yes_no_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_STD_PROPOSE_ONEY === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Select « Yes » if you want to propose FacilyPay Oney in standard payment. Attention, you must ensure that you have a FacilyPay Oney contract.' mod='epaync'}</p>
          </div>
        {/if}
        </fieldset>
        <div class="clear">&nbsp;</div>

      <fieldset>
        <legend>{l s='ADVANCED OPTIONS' mod='epaync'}</legend>

        <label for="EPAYNC_STD_CARD_DATA_MODE">{l s='Card data entry mode' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_STD_CARD_DATA_MODE" name="EPAYNC_STD_CARD_DATA_MODE" onchange="javascript: epayncCardEntryChanged();">
            {foreach from=$epaync_card_data_mode_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_STD_CARD_DATA_MODE === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <input type="hidden" id="EPAYNC_STD_CARD_DATA_MODE_OLD" name="EPAYNC_STD_CARD_DATA_MODE_OLD" value="{$EPAYNC_STD_CARD_DATA_MODE|escape:'html':'UTF-8'}"/>
          <p>{l s='Select how the card data will be entered. Attention, to use bank data acquisition on the merchant site, you must ensure that you have subscribed to this option with your bank.' mod='epaync'}</p>
        </div>

        <div id="EPAYNC_STD_CANCEL_IFRAME_MENU" {if $EPAYNC_STD_CARD_DATA_MODE !== '4'} style="display: none;"{/if}>
          <label for="EPAYNC_STD_CANCEL_IFRAME">{l s='Cancel payment in iframe mode' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_STD_CANCEL_IFRAME" name="EPAYNC_STD_CANCEL_IFRAME">
              {foreach from=$epaync_yes_no_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_STD_CANCEL_IFRAME === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Select « Yes » if you want to propose payment cancellation in iframe mode.' mod='epaync'}</p>
          </div>
        </div>

        <div id="EPAYNC_REST_SETTINGS" {if $EPAYNC_STD_CARD_DATA_MODE != '5' && $EPAYNC_STD_CARD_DATA_MODE != '6'} style="display: none;"{/if}>
          <label for="EPAYNC_STD_REST_THEME">{l s='Theme' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_STD_REST_THEME" name="EPAYNC_STD_REST_THEME">
              {foreach from=$epaync_std_rest_theme_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_STD_REST_THEME === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Select a theme to use to display embedded payment fields. For more customization, you can edit module template manually.' mod='epaync'}</p>
          </div>
          <p></p>

          <label for="EPAYNC_STD_REST_PLACEHLDR">{l s='Custom fields placeholders' mod='epaync'}</label>
          <div class="margin-form">
            <table class="table" cellspacing="0" cellpadding="10">
              <tbody>
                <tr>
                  <td>{l s='Card number' mod='epaync'}</td>
                  <td>
                    {include file="./input_text_lang.tpl"
                      languages=$prestashop_languages
                      current_lang=$prestashop_lang
                      input_name="EPAYNC_STD_REST_PLACEHLDR[pan]"
                      field_id="EPAYNC_STD_REST_PLACEHLDR_pan"
                      input_value=$EPAYNC_STD_REST_PLACEHLDR.pan
                      style="width: 150px;"
                    }
                  </td>
                </tr>

                <tr>
                  <td>{l s='Expiry date' mod='epaync'}</td>
                  <td>
                    {include file="./input_text_lang.tpl"
                      languages=$prestashop_languages
                      current_lang=$prestashop_lang
                      input_name="EPAYNC_STD_REST_PLACEHLDR[expiry]"
                      field_id="EPAYNC_STD_REST_PLACEHLDR_expiry"
                      input_value=$EPAYNC_STD_REST_PLACEHLDR.expiry
                      style="width: 150px;"
                    }
                  </td>
                </tr>

                <tr>
                  <td>{l s='CVV' mod='epaync'}</td>
                  <td>
                    {include file="./input_text_lang.tpl"
                      languages=$prestashop_languages
                      current_lang=$prestashop_lang
                      input_name="EPAYNC_STD_REST_PLACEHLDR[cvv]"
                      field_id="EPAYNC_STD_REST_PLACEHLDR_cvv"
                      input_value=$EPAYNC_STD_REST_PLACEHLDR.cvv
                      style="width: 150px;"
                    }
                  </td>
                </tr>

              </tbody>
            </table>
            <p>{l s='Texts to use as placeholders for embedded payment fields.' mod='epaync'}</p>
          </div>
          <p></p>

          <label>{l s='Register card label' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./input_text_lang.tpl"
              languages=$prestashop_languages
              current_lang=$prestashop_lang
              input_name="EPAYNC_STD_REST_LBL_REGIST"
              input_value=$EPAYNC_STD_REST_LBL_REGIST
              style="width: 330px;"
            }
            <p>{l s='Label displayed to invite buyers to register their card data.' mod='epaync'}</p>
          </div>
          <p></p>

          <label for="EPAYNC_STD_REST_ATTEMPTS">{l s='Payment attempts number' mod='epaync'}</label>
          <div class="margin-form">
            <input type="text" id="EPAYNC_STD_REST_ATTEMPTS" name="EPAYNC_STD_REST_ATTEMPTS" value="{$EPAYNC_STD_REST_ATTEMPTS|escape:'html':'UTF-8'}" style="width: 150px;" />
            <p>{l s='Maximum number of payment retries after a failed payment (between 0 and 9). If blank, the gateway default value is 3.' mod='epaync'}</p>
          </div>
          <p></p>

        </div>

        <div id="EPAYNC_STD_1_CLICK_PAYMENT_MENU">
          <label for="EPAYNC_STD_1_CLICK_PAYMENT">{l s='Payment by token' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_STD_1_CLICK_PAYMENT" name="EPAYNC_STD_1_CLICK_PAYMENT">
              {foreach from=$epaync_yes_no_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_STD_1_CLICK_PAYMENT === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='This option allows to pay orders without re-entering bank data at each payment. The "payment by token" option should be enabled on your %s store to use this feature.' sprintf='EpayNC' mod='epaync'}</p>
          </div>

        </div>

      </fieldset>
      <div class="clear">&nbsp;</div>
    </div>

    {if $epaync_plugin_features['multi']}
      <h4 style="font-weight: bold; margin-bottom: 0; overflow: hidden; line-height: unset !important;">
        <a href="#">{l s='PAYMENT IN INSTALLMENTS' mod='epaync'}</a>
      </h4>
      <div>
        {if $epaync_plugin_features['restrictmulti']}
          <p style="background: none repeat scroll 0 0 #FFFFE0; border: 1px solid #E6DB55; font-size: 13px; margin: 0 0 20px; padding: 10px;">
            {l s='ATTENTION: The payment in installments feature activation is subject to the prior agreement of Société Générale.' mod='epaync'}<br />
            {l s='If you enable this feature while you have not the associated option, an error 10000 – INSTALLMENTS_NOT_ALLOWED or 07 - PAYMENT_CONFIG will occur and the buyer will not be able to pay.' mod='epaync'}
          </p>
        {/if}

        <fieldset>
          <legend>{l s='MODULE OPTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_MULTI_ENABLED">{l s='Activation' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_MULTI_ENABLED" name="EPAYNC_MULTI_ENABLED">
              {foreach from=$epaync_enable_disable_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_MULTI_ENABLED === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Enables / disables this payment method.' mod='epaync'}</p>
          </div>

          <label>{l s='Payment method title' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./input_text_lang.tpl"
              languages=$prestashop_languages
              current_lang=$prestashop_lang
              input_name="EPAYNC_MULTI_TITLE"
              input_value=$EPAYNC_MULTI_TITLE
              style="width: 330px;"
            }
            <p>{l s='Method title to display on payment means page.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='RESTRICTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_MULTI_COUNTRY">{l s='Restrict to some countries' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_MULTI_COUNTRY" name="EPAYNC_MULTI_COUNTRY" onchange="javascript: epayncCountriesRestrictMenuDisplay('EPAYNC_MULTI_COUNTRY')">
              {foreach from=$epaync_countries_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_MULTI_COUNTRY === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Buyer\'s billing countries in which this payment method is available.' mod='epaync'}</p>
          </div>

          <div id="EPAYNC_MULTI_COUNTRY_MENU" {if $EPAYNC_MULTI_COUNTRY === '1'} style="display: none;"{/if}>
            <label for="EPAYNC_MULTI_COUNTRY_LST">{l s='Authorized countries' mod='epaync'}</label>
            <div class="margin-form">
              <select id="EPAYNC_MULTI_COUNTRY_LST" name="EPAYNC_MULTI_COUNTRY_LST[]" multiple="multiple" size="7">
                {foreach from=$epaync_countries_list['ps_countries'] key="key" item="option"}
                  <option value="{$key|escape:'html':'UTF-8'}"{if in_array($key, $EPAYNC_MULTI_COUNTRY_LST)} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                {/foreach}
              </select>
            </div>
          </div>

          <label>{l s='Customer group amount restriction' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./table_amount_group.tpl"
              groups=$prestashop_groups
              input_name="EPAYNC_MULTI_AMOUNTS"
              input_value=$EPAYNC_MULTI_AMOUNTS
            }
            <p>{l s='Define amount restriction for each customer group.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='PAYMENT PAGE' mod='epaync'}</legend>

          <label for="EPAYNC_MULTI_DELAY">{l s='Capture delay' mod='epaync'}</label>
          <div class="margin-form">
            <input id="EPAYNC_MULTI_DELAY" name="EPAYNC_MULTI_DELAY" value="{$EPAYNC_MULTI_DELAY|escape:'html':'UTF-8'}" type="text">
            <p>{l s='The number of days before the bank capture. Enter value only if different from « Base settings ».' mod='epaync'}</p>
          </div>

          <label for="EPAYNC_MULTI_VALIDATION">{l s='Validation mode' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_MULTI_VALIDATION" name="EPAYNC_MULTI_VALIDATION">
              <option value="-1"{if $EPAYNC_MULTI_VALIDATION === '-1'} selected="selected"{/if}>{l s='Base settings configuration' mod='epaync'}</option>
              {foreach from=$epaync_validation_mode_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_MULTI_VALIDATION === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='If manual is selected, you will have to confirm payments manually in your bank Back Office.' mod='epaync'}</p>
          </div>

          <label for="EPAYNC_MULTI_PAYMENT_CARDS">{l s='Card Types' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_MULTI_PAYMENT_CARDS" name="EPAYNC_MULTI_PAYMENT_CARDS[]" multiple="multiple" size="7">
              {foreach from=$epaync_multi_payment_cards_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if in_array($key, $EPAYNC_MULTI_PAYMENT_CARDS)} selected="selected"{/if}>{if $key !== ""} {$key|escape:'html':'UTF-8'} - {/if}{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='The card type(s) that can be used for the payment. Select none to use gateway configuration.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='ADVANCED OPTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_MULTI_CARD_MODE">{l s='Card type selection' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_MULTI_CARD_MODE" name="EPAYNC_MULTI_CARD_MODE">
              {foreach from=$epaync_card_selection_mode_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_MULTI_CARD_MODE === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Select where the card type will be selected by the buyer.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='PAYMENT OPTIONS' mod='epaync'}</legend>

          <label>{l s='Payment options' mod='epaync'}</label>
          <div class="margin-form">
            <script type="text/html" id="epaync_multi_row_option">
              {include file="./row_multi_option.tpl"
                languages=$prestashop_languages
                current_lang=$prestashop_lang
                key="EPAYNC_MULTI_KEY"
                option=$epaync_default_multi_option
              }
            </script>

            <button type="button" id="epaync_multi_options_btn"{if !empty($EPAYNC_MULTI_OPTIONS)} style="display: none;"{/if} onclick="javascript: epayncAddMultiOption(true, '{l s='Delete' mod='epaync'}');">{l s='Add' mod='epaync'}</button>

            <table id="epaync_multi_options_table"{if empty($EPAYNC_MULTI_OPTIONS)} style="display: none;"{/if} class="table" cellpadding="10" cellspacing="0">
              <thead>
                <tr>
                  <th style="font-size: 10px;">{l s='Label' mod='epaync'}</th>
                  <th style="font-size: 10px;">{l s='Min amount' mod='epaync'}</th>
                  <th style="font-size: 10px;">{l s='Max amount' mod='epaync'}</th>
                  {if in_array('CB', $epaync_multi_payment_cards_options)}
                    <th style="font-size: 10px;">{l s='Contract' mod='epaync'}</th>
                  {/if}
                  <th style="font-size: 10px;">{l s='Count' mod='epaync'}</th>
                  <th style="font-size: 10px;">{l s='Period' mod='epaync'}</th>
                  <th style="font-size: 10px;">{l s='1st payment' mod='epaync'}</th>
                  <th style="font-size: 10px;"></th>
                </tr>
              </thead>

              <tbody>
                {foreach from=$EPAYNC_MULTI_OPTIONS key="key" item="option"}
                  {include file="./row_multi_option.tpl"
                    languages=$prestashop_languages
                    current_lang=$prestashop_lang
                    key=$key
                    option=$option
                  }
                {/foreach}

                <tr id="epaync_multi_option_add">
                  <td colspan="{if in_array('CB', $epaync_multi_payment_cards_options)}7{else}6{/if}"></td>
                  <td>
                    <button type="button" onclick="javascript: epayncAddMultiOption(false, '{l s='Delete' mod='epaync'}');">{l s='Add' mod='epaync'}</button>
                  </td>
                </tr>
              </tbody>
            </table>
            <p>
              {l s='Click on « Add » button to configure one or more payment options.' mod='epaync'}<br />
              <b>{l s='Label' mod='epaync'} : </b>{l s='The option label to display on the frontend.' mod='epaync'}<br />
              <b>{l s='Min amount' mod='epaync'} : </b>{l s='Minimum amount to enable the payment option.' mod='epaync'}<br />
              <b>{l s='Max amount' mod='epaync'} : </b>{l s='Maximum amount to enable the payment option.' mod='epaync'}<br />
              {if in_array('CB', $epaync_multi_payment_cards_options)}
                <b>{l s='Contract' mod='epaync'} : </b>{l s='ID of the contract to use with the option (Leave blank preferably).' mod='epaync'}<br />
              {/if}
              <b>{l s='Count' mod='epaync'} : </b>{l s='Total number of payments.' mod='epaync'}<br />
              <b>{l s='Period' mod='epaync'} : </b>{l s='Delay (in days) between payments.' mod='epaync'}<br />
              <b>{l s='1st payment' mod='epaync'} : </b>{l s='Amount of first payment, in percentage of total amount. If empty, all payments will have the same amount.' mod='epaync'}<br />
              <b>{l s='Do not forget to click on « Save » button to save your modifications.' mod='epaync'}</b>
            </p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>
      </div>
    {/if}

    {if $epaync_plugin_features['choozeo']}
      <h4 style="font-weight: bold; margin-bottom: 0; overflow: hidden; line-height: unset !important;">
        <a href="#">{l s='CHOOZEO PAYMENT' mod='epaync'}</a>
      </h4>
      <div>
        <fieldset>
          <legend>{l s='MODULE OPTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_CHOOZEO_ENABLED">{l s='Activation' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_CHOOZEO_ENABLED" name="EPAYNC_CHOOZEO_ENABLED">
              {foreach from=$epaync_enable_disable_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_CHOOZEO_ENABLED === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Enables / disables this payment method.' mod='epaync'}</p>
          </div>

          <label>{l s='Payment method title' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./input_text_lang.tpl"
              languages=$prestashop_languages
              current_lang=$prestashop_lang
              input_name="EPAYNC_CHOOZEO_TITLE"
              input_value=$EPAYNC_CHOOZEO_TITLE
              style="width: 330px;"
            }
            <p>{l s='Method title to display on payment means page.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='RESTRICTIONS' mod='epaync'}</legend>

          {if isset ($epaync_countries_list['CHOOZEO'])}
            <label for="EPAYNC_CHOOZEO_COUNTRY">{l s='Restrict to some countries' mod='epaync'}</label>
            <div class="margin-form">
              <select id="EPAYNC_CHOOZEO_COUNTRY" name="EPAYNC_CHOOZEO_COUNTRY" onchange="javascript: epayncCountriesRestrictMenuDisplay('EPAYNC_CHOOZEO_COUNTRY')">
                {foreach from=$epaync_countries_options key="key" item="option"}
                  <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_CHOOZEO_COUNTRY === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                {/foreach}
              </select>
              <p>{l s='Buyer\'s billing countries in which this payment method is available.' mod='epaync'}</p>
            </div>

            <div id="EPAYNC_CHOOZEO_COUNTRY_MENU" {if $EPAYNC_CHOOZEO_COUNTRY === '1'} style="display: none;"{/if}>
              <label for="EPAYNC_CHOOZEO_COUNTRY_LST">{l s='Authorized countries' mod='epaync'}</label>
              <div class="margin-form">
                <select id="EPAYNC_CHOOZEO_COUNTRY_LST" name="EPAYNC_CHOOZEO_COUNTRY_LST[]" multiple="multiple" size="7">
                  {if isset ($epaync_countries_list['CHOOZEO'])}
                      {foreach from=$epaync_countries_list['CHOOZEO'] key="key" item="option"}
                          <option value="{$key|escape:'html':'UTF-8'}"{if in_array($key, $EPAYNC_CHOOZEO_COUNTRY_LST)} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                      {/foreach}
                  {/if}
                </select>
              </div>
            </div>
          {else}
            <input type="hidden" name ="EPAYNC_CHOOZEO_COUNTRY" value="1">
            <input type="hidden" name ="EPAYNC_CHOOZEO_COUNTRY_LST[]" value ="">
            <p style="background: none repeat scroll 0 0 #FFFFE0; border: 1px solid #E6DB55; font-size: 13px; margin: 0 0 20px; padding: 10px;">
                {l s='Payment method unavailable for the list of countries defined on your PrestaShop store.' mod='epaync'}
            </p>
          {/if}

          <label>{l s='Customer group amount restriction' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./table_amount_group.tpl"
              groups=$prestashop_groups
              input_name="EPAYNC_CHOOZEO_AMOUNTS"
              input_value=$EPAYNC_CHOOZEO_AMOUNTS
            }
            <p>{l s='Define amount restriction for each customer group.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='PAYMENT PAGE' mod='epaync'}</legend>

          <label for="EPAYNC_CHOOZEO_DELAY">{l s='Capture delay' mod='epaync'}</label>
          <div class="margin-form">
            <input id="EPAYNC_CHOOZEO_DELAY" name="EPAYNC_CHOOZEO_DELAY" value="{$EPAYNC_CHOOZEO_DELAY|escape:'html':'UTF-8'}" type="text">
            <p>{l s='The number of days before the bank capture. Enter value only if different from « Base settings ».' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='PAYMENT OPTIONS' mod='epaync'}</legend>

          <label>{l s='Payment options' mod='epaync'}</label>
          <div class="margin-form">
            <table class="table" cellpadding="10" cellspacing="0">
              <thead>
                <tr>
                  <th>{l s='Activation' mod='epaync'}</th>
                  <th>{l s='Label' mod='epaync'}</th>
                  <th>{l s='Min amount' mod='epaync'}</th>
                  <th>{l s='Max amount' mod='epaync'}</th>
                </tr>
              </thead>

              <tbody>
                <tr>
                  <td>
                    <input name="EPAYNC_CHOOZEO_OPTIONS[EPNF_3X][enabled]"
                      style="width: 100%;"
                      type="checkbox"
                      value="True"
                      {if !isset($EPAYNC_CHOOZEO_OPTIONS.EPNF_3X.enabled) || ($EPAYNC_CHOOZEO_OPTIONS.EPNF_3X.enabled ==='True')}checked{/if}>
                  </td>
                  <td>Choozeo 3X CB</td>
                  <td>
                    <input name="EPAYNC_CHOOZEO_OPTIONS[EPNF_3X][min_amount]"
                      value="{if isset($EPAYNC_CHOOZEO_OPTIONS['EPNF_3X'])}{$EPAYNC_CHOOZEO_OPTIONS['EPNF_3X']['min_amount']|escape:'html':'UTF-8'}{/if}"
                      style="width: 200px;"
                      type="text">
                  </td>
                  <td>
                    <input name="EPAYNC_CHOOZEO_OPTIONS[EPNF_3X][max_amount]"
                      value="{if isset($EPAYNC_CHOOZEO_OPTIONS['EPNF_3X'])}{$EPAYNC_CHOOZEO_OPTIONS['EPNF_3X']['max_amount']|escape:'html':'UTF-8'}{/if}"
                      style="width: 200px;"
                      type="text">
                  </td>
                </tr>

                <tr>
                  <td>
                    <input name="EPAYNC_CHOOZEO_OPTIONS[EPNF_4X][enabled]"
                      style="width: 100%;"
                      type="checkbox"
                      value="True"
                      {if !isset($EPAYNC_CHOOZEO_OPTIONS.EPNF_4X.enabled) || ($EPAYNC_CHOOZEO_OPTIONS.EPNF_4X.enabled ==='True')}checked{/if}>
                  </td>
                  <td>Choozeo 4X CB</td>
                  <td>
                    <input name="EPAYNC_CHOOZEO_OPTIONS[EPNF_4X][min_amount]"
                      value="{if isset($EPAYNC_CHOOZEO_OPTIONS['EPNF_4X'])}{$EPAYNC_CHOOZEO_OPTIONS['EPNF_4X']['min_amount']|escape:'html':'UTF-8'}{/if}"
                      style="width: 200px;"
                      type="text">
                  </td>
                  <td>
                    <input name="EPAYNC_CHOOZEO_OPTIONS[EPNF_4X][max_amount]"
                      value="{if isset($EPAYNC_CHOOZEO_OPTIONS['EPNF_4X'])}{$EPAYNC_CHOOZEO_OPTIONS['EPNF_4X']['max_amount']|escape:'html':'UTF-8'}{/if}"
                      style="width: 200px;"
                      type="text">
                  </td>
                </tr>
              </tbody>
            </table>
            <p>{l s='Define amount restriction for each card.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>
      </div>
    {/if}

    {if $epaync_plugin_features['oney']}
      <h4 style="font-weight: bold; margin-bottom: 0; overflow: hidden; line-height: unset !important;">
        <a href="#">{l s='PAYMENT IN 3 OR 4 TIMES ONEY' mod='epaync'}</a>
      </h4>
      <div>
        <fieldset>
          <legend>{l s='MODULE OPTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_ONEY34_ENABLED">{l s='Activation' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_ONEY34_ENABLED" name="EPAYNC_ONEY34_ENABLED">
              {foreach from=$epaync_enable_disable_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_ONEY34_ENABLED === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Enables / disables this payment method.' mod='epaync'}</p>
          </div>

          <label>{l s='Payment method title' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./input_text_lang.tpl"
              languages=$prestashop_languages
              current_lang=$prestashop_lang
              input_name="EPAYNC_ONEY34_TITLE"
              input_value=$EPAYNC_ONEY34_TITLE
              style="width: 330px;"
            }
            <p>{l s='Method title to display on payment means page.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='RESTRICTIONS' mod='epaync'}</legend>

          {if isset ($epaync_countries_list['ONEY'])}
            <label for="EPAYNC_ONEY34_COUNTRY">{l s='Restrict to some countries' mod='epaync'}</label>
            <div class="margin-form">
              <select id="EPAYNC_ONEY34_COUNTRY" name="EPAYNC_ONEY34_COUNTRY" onchange="javascript: epayncCountriesRestrictMenuDisplay('EPAYNC_ONEY34_COUNTRY')">
                {foreach from=$epaync_countries_options key="key" item="option"}
                  <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_ONEY34_COUNTRY === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                {/foreach}
              </select>
              <p>{l s='Buyer\'s billing countries in which this payment method is available.' mod='epaync'}</p>
            </div>

            <div id="EPAYNC_ONEY34_COUNTRY_MENU" {if $EPAYNC_ONEY34_COUNTRY === '1'} style="display: none;"{/if}>
              <label for="EPAYNC_ONEY34_COUNTRY_LST">{l s='Authorized countries' mod='epaync'}</label>
              <div class="margin-form">
                <select id="EPAYNC_ONEY34_COUNTRY_LST" name="EPAYNC_ONEY34_COUNTRY_LST[]" multiple="multiple" size="7">
                  {if isset ($epaync_countries_list['ONEY'])}
                      {foreach from=$epaync_countries_list['ONEY'] key="key" item="option"}
                          <option value="{$key|escape:'html':'UTF-8'}"{if in_array($key, $EPAYNC_ONEY34_COUNTRY_LST)} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                      {/foreach}
                  {/if}
                </select>
              </div>
            </div>
          {else}
            <input type="hidden" name ="EPAYNC_ONEY34_COUNTRY" value="1">
            <input type="hidden" name ="EPAYNC_ONEY34_COUNTRY_LST[]" value ="">
            <p style="background: none repeat scroll 0 0 #FFFFE0; border: 1px solid #E6DB55; font-size: 13px; margin: 0 0 20px; padding: 10px;">
                {l s='Payment method unavailable for the list of countries defined on your PrestaShop store.' mod='epaync'}
            </p>
          {/if}

          <label>{l s='Customer group amount restriction' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./table_amount_group.tpl"
              groups=$prestashop_groups
              input_name="EPAYNC_ONEY34_AMOUNTS"
              input_value=$EPAYNC_ONEY34_AMOUNTS
            }
            <p>{l s='Define amount restriction for each customer group.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='PAYMENT PAGE' mod='epaync'}</legend>

          <label for="EPAYNC_ONEY34_DELAY">{l s='Capture delay' mod='epaync'}</label>
          <div class="margin-form">
            <input id="EPAYNC_ONEY34_DELAY" name="EPAYNC_ONEY34_DELAY" value="{$EPAYNC_ONEY34_DELAY|escape:'html':'UTF-8'}" type="text">
            <p>{l s='The number of days before the bank capture. Enter value only if different from « Base settings ».' mod='epaync'}</p>
          </div>

          <label for="EPAYNC_ONEY34_VALIDATION">{l s='Validation mode' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_ONEY34_VALIDATION" name="EPAYNC_ONEY34_VALIDATION">
              <option value="-1"{if $EPAYNC_ONEY34_VALIDATION === '-1'} selected="selected"{/if}>{l s='Base settings configuration' mod='epaync'}</option>
              {foreach from=$epaync_validation_mode_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_ONEY34_VALIDATION === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='If manual is selected, you will have to confirm payments manually in your bank Back Office.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='PAYMENT OPTIONS' mod='epaync'}</legend>

          <label>{l s='Payment options' mod='epaync'}</label>
          <div class="margin-form">
            <script type="text/html" id="epaync_oney34_row_option">
              {include file="./row_oney_option.tpl"
                languages=$prestashop_languages
                current_lang=$prestashop_lang
                key="EPAYNC_ONEY34_KEY"
                option=$epaync_default_oney_option
                suffix='34'
              }
            </script>

            <button type="button" id="epaync_oney34_options_btn"{if !empty($EPAYNC_ONEY34_OPTIONS)} style="display: none;"{/if} onclick="javascript: epayncAddOneyOption(true, '34');">{l s='Add' mod='epaync'}</button>

            <table id="epaync_oney34_options_table"{if empty($EPAYNC_ONEY34_OPTIONS)} style="display: none;"{/if} class="table" cellpadding="10" cellspacing="0">
              <thead>
                <tr>
                  <th style="font-size: 10px;">{l s='Label' mod='epaync'}</th>
                  <th style="font-size: 10px;">{l s='Code' mod='epaync'}</th>
                  <th style="font-size: 10px;">{l s='Min amount' mod='epaync'}</th>
                  <th style="font-size: 10px;">{l s='Max amount' mod='epaync'}</th>
                  <th style="font-size: 10px;">{l s='Count' mod='epaync'}</th>
                  <th style="font-size: 10px;">{l s='Rate' mod='epaync'}</th>
                  <th style="font-size: 10px;"></th>
                </tr>
              </thead>

              <tbody>
                {foreach from=$EPAYNC_ONEY34_OPTIONS key="key" item="option"}
                  {include file="./row_oney_option.tpl"
                    languages=$prestashop_languages
                    current_lang=$prestashop_lang
                    key=$key
                    option=$option
                    suffix='34'
                  }
                {/foreach}

                <tr id="epaync_oney34_option_add">
                  <td colspan="6"></td>
                  <td>
                    <button type="button" onclick="javascript: epayncAddOneyOption(false, '34');">{l s='Add' mod='epaync'}</button>
                  </td>
                </tr>
              </tbody>
            </table>
            <p>
              {l s='Click on « Add » button to configure one or more payment options.' mod='epaync'}<br />
              <b>{l s='Label' mod='epaync'} : </b>{l s='The option label to display on the frontend (the %c and %r patterns will be respectively replaced by payments count and option rate).' mod='epaync'}<br />
              <b>{l s='Code' mod='epaync'} : </b>{l s='The option code as defined in your Oney contract.' mod='epaync'}<br />
              <b>{l s='Min amount' mod='epaync'} : </b>{l s='Minimum amount to enable the payment option.' mod='epaync'}<br />
              <b>{l s='Max amount' mod='epaync'} : </b>{l s='Maximum amount to enable the payment option.' mod='epaync'}<br />
              <b>{l s='Count' mod='epaync'} : </b>{l s='Total number of payments.' mod='epaync'}<br />
              <b>{l s='Rate' mod='epaync'} : </b>{l s='The interest rate in percentage.' mod='epaync'}<br />
              <b>{l s='Do not forget to click on « Save » button to save your modifications.' mod='epaync'}</b>
            </p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>
      </div>
    {/if}

    {if $epaync_plugin_features['oney']}
      <h4 style="font-weight: bold; margin-bottom: 0; overflow: hidden; line-height: unset !important;">
        <a href="#">{l s='FACILYPAY ONEY PAYMENT' mod='epaync'}</a>
      </h4>
      <div>
        <fieldset>
          <legend>{l s='MODULE OPTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_ONEY_ENABLED">{l s='Activation' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_ONEY_ENABLED" name="EPAYNC_ONEY_ENABLED">
              {foreach from=$epaync_enable_disable_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_ONEY_ENABLED === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Enables / disables this payment method.' mod='epaync'}</p>
          </div>

          <label>{l s='Payment method title' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./input_text_lang.tpl"
              languages=$prestashop_languages
              current_lang=$prestashop_lang
              input_name="EPAYNC_ONEY_TITLE"
              input_value=$EPAYNC_ONEY_TITLE
              style="width: 330px;"
            }
            <p>{l s='Method title to display on payment means page.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='RESTRICTIONS' mod='epaync'}</legend>

          {if isset ($epaync_countries_list['ONEY'])}
            <label for="EPAYNC_ONEY_COUNTRY">{l s='Restrict to some countries' mod='epaync'}</label>
            <div class="margin-form">
              <select id="EPAYNC_ONEY_COUNTRY" name="EPAYNC_ONEY_COUNTRY" onchange="javascript: epayncCountriesRestrictMenuDisplay('EPAYNC_ONEY_COUNTRY')">
                {foreach from=$epaync_countries_options key="key" item="option"}
                  <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_ONEY_COUNTRY === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                {/foreach}
              </select>
              <p>{l s='Buyer\'s billing countries in which this payment method is available.' mod='epaync'}</p>
            </div>

            <div id="EPAYNC_ONEY_COUNTRY_MENU" {if $EPAYNC_ONEY_COUNTRY === '1'} style="display: none;"{/if}>
              <label for="EPAYNC_ONEY_COUNTRY_LST">{l s='Authorized countries' mod='epaync'}</label>
              <div class="margin-form">
                <select id="EPAYNC_ONEY_COUNTRY_LST" name="EPAYNC_ONEY_COUNTRY_LST[]" multiple="multiple" size="7">
                  {if isset ($epaync_countries_list['ONEY'])}
                      {foreach from=$epaync_countries_list['ONEY'] key="key" item="option"}
                          <option value="{$key|escape:'html':'UTF-8'}"{if in_array($key, $EPAYNC_ONEY_COUNTRY_LST)} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                      {/foreach}
                  {/if}
                </select>
              </div>
            </div>
          {else}
            <input type="hidden" name ="EPAYNC_ONEY_COUNTRY" value="1">
            <input type="hidden" name ="EPAYNC_ONEY_COUNTRY_LST[]" value ="">
            <p style="background: none repeat scroll 0 0 #FFFFE0; border: 1px solid #E6DB55; font-size: 13px; margin: 0 0 20px; padding: 10px;">
                {l s='Payment method unavailable for the list of countries defined on your PrestaShop store.' mod='epaync'}
            </p>
          {/if}

          <label>{l s='Customer group amount restriction' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./table_amount_group.tpl"
              groups=$prestashop_groups
              input_name="EPAYNC_ONEY_AMOUNTS"
              input_value=$EPAYNC_ONEY_AMOUNTS
            }
            <p>{l s='Define amount restriction for each customer group.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='PAYMENT PAGE' mod='epaync'}</legend>

          <label for="EPAYNC_ONEY_DELAY">{l s='Capture delay' mod='epaync'}</label>
          <div class="margin-form">
            <input id="EPAYNC_ONEY_DELAY" name="EPAYNC_ONEY_DELAY" value="{$EPAYNC_ONEY_DELAY|escape:'html':'UTF-8'}" type="text">
            <p>{l s='The number of days before the bank capture. Enter value only if different from « Base settings ».' mod='epaync'}</p>
          </div>

          <label for="EPAYNC_ONEY_VALIDATION">{l s='Validation mode' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_ONEY_VALIDATION" name="EPAYNC_ONEY_VALIDATION">
              <option value="-1"{if $EPAYNC_ONEY_VALIDATION === '-1'} selected="selected"{/if}>{l s='Base settings configuration' mod='epaync'}</option>
              {foreach from=$epaync_validation_mode_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_ONEY_VALIDATION === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='If manual is selected, you will have to confirm payments manually in your bank Back Office.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='PAYMENT OPTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_ONEY_ENABLE_OPTIONS">{l s='Enable options selection' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_ONEY_ENABLE_OPTIONS" name="EPAYNC_ONEY_ENABLE_OPTIONS" onchange="javascript: epayncOneyEnableOptionsChanged();">
              {foreach from=$epaync_yes_no_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_ONEY_ENABLE_OPTIONS === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Enable payment options selection on merchant site.' mod='epaync'}</p>
          </div>

          <section id="epaync_oney_options_settings">
            <label>{l s='Payment options' mod='epaync'}</label>
            <div class="margin-form">
              <script type="text/html" id="epaync_oney_row_option">
                {include file="./row_oney_option.tpl"
                  languages=$prestashop_languages
                  current_lang=$prestashop_lang
                  key="EPAYNC_ONEY_KEY"
                  option=$epaync_default_oney_option
                  suffix=''
                }
              </script>

              <button type="button" id="epaync_oney_options_btn"{if !empty($EPAYNC_ONEY_OPTIONS)} style="display: none;"{/if} onclick="javascript: epayncAddOneyOption(true, '');">{l s='Add' mod='epaync'}</button>

              <table id="epaync_oney_options_table"{if empty($EPAYNC_ONEY_OPTIONS)} style="display: none;"{/if} class="table" cellpadding="10" cellspacing="0">
                <thead>
                  <tr>
                    <th style="font-size: 10px;">{l s='Label' mod='epaync'}</th>
                    <th style="font-size: 10px;">{l s='Code' mod='epaync'}</th>
                    <th style="font-size: 10px;">{l s='Min amount' mod='epaync'}</th>
                    <th style="font-size: 10px;">{l s='Max amount' mod='epaync'}</th>
                    <th style="font-size: 10px;">{l s='Count' mod='epaync'}</th>
                    <th style="font-size: 10px;">{l s='Rate' mod='epaync'}</th>
                    <th style="font-size: 10px;"></th>
                  </tr>
                </thead>

                <tbody>
                  {foreach from=$EPAYNC_ONEY_OPTIONS key="key" item="option"}
                    {include file="./row_oney_option.tpl"
                      languages=$prestashop_languages
                      current_lang=$prestashop_lang
                      key=$key
                      option=$option
                      suffix=''
                    }
                  {/foreach}

                  <tr id="epaync_oney_option_add">
                    <td colspan="6"></td>
                    <td>
                      <button type="button" onclick="javascript: epayncAddOneyOption(false, '');">{l s='Add' mod='epaync'}</button>
                    </td>
                  </tr>
                </tbody>
              </table>
              <p>
                {l s='Click on « Add » button to configure one or more payment options.' mod='epaync'}<br />
                <b>{l s='Label' mod='epaync'} : </b>{l s='The option label to display on the frontend (the %c and %r patterns will be respectively replaced by payments count and option rate).' mod='epaync'}<br />
                <b>{l s='Code' mod='epaync'} : </b>{l s='The option code as defined in your FacilyPay Oney contract.' mod='epaync'}<br />
                <b>{l s='Min amount' mod='epaync'} : </b>{l s='Minimum amount to enable the payment option.' mod='epaync'}<br />
                <b>{l s='Max amount' mod='epaync'} : </b>{l s='Maximum amount to enable the payment option.' mod='epaync'}<br />
                <b>{l s='Count' mod='epaync'} : </b>{l s='Total number of payments.' mod='epaync'}<br />
                <b>{l s='Rate' mod='epaync'} : </b>{l s='The interest rate in percentage.' mod='epaync'}<br />
                <b>{l s='Do not forget to click on « Save » button to save your modifications.' mod='epaync'}</b>
              </p>
            </div>
          </section>

          <script type="text/javascript">
            epayncOneyEnableOptionsChanged();
          </script>
        </fieldset>
        <div class="clear">&nbsp;</div>
      </div>
    {/if}

    {if $epaync_plugin_features['franfinance']}
      <h4 style="font-weight: bold; margin-bottom: 0; overflow: hidden; line-height: unset !important;">
        <a href="#">{l s='FRANFINANCE PAYMENT' mod='epaync'}</a>
      </h4>
      <div>
        <fieldset>
          <legend>{l s='MODULE OPTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_FFIN_ENABLED">{l s='Activation' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_FFIN_ENABLED" name="EPAYNC_FFIN_ENABLED">
              {foreach from=$epaync_enable_disable_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_FFIN_ENABLED === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Enables / disables this payment method.' mod='epaync'}</p>
          </div>

          <label>{l s='Payment method title' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./input_text_lang.tpl"
              languages=$prestashop_languages
              current_lang=$prestashop_lang
              input_name="EPAYNC_FFIN_TITLE"
              input_value=$EPAYNC_FFIN_TITLE
              style="width: 330px;"
            }
            <p>{l s='Method title to display on payment means page.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='RESTRICTIONS' mod='epaync'}</legend>

          {if isset ($epaync_countries_list['FFIN'])}
            <label for="EPAYNC_FFIN_COUNTRY">{l s='Restrict to some countries' mod='epaync'}</label>
            <div class="margin-form">
              <select id="EPAYNC_FFIN_COUNTRY" name="EPAYNC_FFIN_COUNTRY" onchange="javascript: epayncCountriesRestrictMenuDisplay('EPAYNC_FFIN_COUNTRY')">
                {foreach from=$epaync_countries_options key="key" item="option"}
                  <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_FFIN_COUNTRY === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                {/foreach}
              </select>
              <p>{l s='Buyer\'s billing countries in which this payment method is available.' mod='epaync'}</p>
            </div>

            <div id="EPAYNC_FFIN_COUNTRY_MENU" {if $EPAYNC_FFIN_COUNTRY === '1'} style="display: none;"{/if}>
              <label for="EPAYNC_FFIN_COUNTRY_LST">{l s='Authorized countries' mod='epaync'}</label>
              <div class="margin-form">
                <select id="EPAYNC_FFIN_COUNTRY_LST" name="EPAYNC_FFIN_COUNTRY_LST[]" multiple="multiple" size="7">
                  {if isset ($epaync_countries_list['FFIN'])}
                      {foreach from=$epaync_countries_list['FFIN'] key="key" item="option"}
                          <option value="{$key|escape:'html':'UTF-8'}"{if in_array($key, $EPAYNC_FFIN_COUNTRY_LST)} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                      {/foreach}
                  {/if}
                </select>
              </div>
            </div>
          {else}
            <input type="hidden" name ="EPAYNC_FFIN_COUNTRY" value="1">
            <input type="hidden" name ="EPAYNC_FFIN_COUNTRY_LST[]" value ="">
            <p style="background: none repeat scroll 0 0 #FFFFE0; border: 1px solid #E6DB55; font-size: 13px; margin: 0 0 20px; padding: 10px;">
                {l s='Payment method unavailable for the list of countries defined on your PrestaShop store.' mod='epaync'}
            </p>
          {/if}

          <label>{l s='Customer group amount restriction' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./table_amount_group.tpl"
              groups=$prestashop_groups
              input_name="EPAYNC_FFIN_AMOUNTS"
              input_value=$EPAYNC_FFIN_AMOUNTS
            }
            <p>{l s='Define amount restriction for each customer group.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='PAYMENT OPTIONS' mod='epaync'}</legend>

          <label>{l s='Payment options' mod='epaync'}</label>
          <div class="margin-form">
            <script type="text/html" id="epaync_ffin_row_option">
              {include file="./row_franfinance_option.tpl"
                languages=$prestashop_languages
                current_lang=$prestashop_lang
                key="EPAYNC_FFIN_KEY"
                option=$epaync_default_franfinance_option
              }
            </script>

            <button type="button" id="epaync_ffin_options_btn"{if !empty($EPAYNC_FFIN_OPTIONS)} style="display: none;"{/if} onclick="javascript: epayncAddFranfinanceOption(true, '{l s='Delete' mod='epaync'}');">{l s='Add' mod='epaync'}</button>

            <table id="epaync_ffin_options_table"{if empty($EPAYNC_FFIN_OPTIONS)} style="display: none;"{/if} class="table" cellpadding="10" cellspacing="0">
              <thead>
                <tr>
                  <th style="font-size: 10px;">{l s='Label' mod='epaync'}</th>
                  <th style="font-size: 10px;">{l s='Count' mod='epaync'}</th>
                  <th style="font-size: 10px;">{l s='Fees' mod='epaync'}</th>
                  <th style="font-size: 10px;">{l s='Min amount' mod='epaync'}</th>
                  <th style="font-size: 10px;">{l s='Max amount' mod='epaync'}</th>
                  <th style="font-size: 10px;"></th>
                </tr>
              </thead>

              <tbody>
                {foreach from=$EPAYNC_FFIN_OPTIONS key="key" item="option"}
                  {include file="./row_franfinance_option.tpl"
                    languages=$prestashop_languages
                    current_lang=$prestashop_lang
                    key=$key
                    option=$option
                  }
                {/foreach}

                <tr id="epaync_ffin_option_add">
                  <td colspan="7"></td>
                  <td>
                    <button type="button" onclick="javascript: epayncAddFranfinanceOption(false, '{l s='Delete' mod='epaync'}');">{l s='Add' mod='epaync'}</button>
                  </td>
                </tr>
              </tbody>
            </table>
            <p>
              {l s='Click on « Add » button to configure one or more payment options.' mod='epaync'}<br />
              <b>{l s='Label' mod='epaync'} : </b>{l s='The option label to display on the frontend (the %c pattern will be replaced by payments count).' mod='epaync'}<br />
              <b>{l s='Count' mod='epaync'} : </b>{l s='Total number of payments.' mod='epaync'}<br />
              <b>{l s='Fees' mod='epaync'} : </b>{l s='Enable or disables fees application.' mod='epaync'}<br />
              <b>{l s='Min amount' mod='epaync'} : </b>{l s='Minimum amount to enable the payment option.' mod='epaync'}<br />
              <b>{l s='Max amount' mod='epaync'} : </b>{l s='Maximum amount to enable the payment option.' mod='epaync'}<br />
              <b>{l s='Do not forget to click on « Save » button to save your modifications.' mod='epaync'}</b>
            </p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>
      </div>
    {/if}

    {if $epaync_plugin_features['fullcb']}
      <h4 style="font-weight: bold; margin-bottom: 0; overflow: hidden; line-height: unset !important;">
        <a href="#">{l s='FULLCB PAYMENT' mod='epaync'}</a>
      </h4>
      <div>
        <fieldset>
          <legend>{l s='MODULE OPTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_FULLCB_ENABLED">{l s='Activation' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_FULLCB_ENABLED" name="EPAYNC_FULLCB_ENABLED">
              {foreach from=$epaync_enable_disable_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_FULLCB_ENABLED === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Enables / disables this payment method.' mod='epaync'}</p>
          </div>

          <label>{l s='Payment method title' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./input_text_lang.tpl"
              languages=$prestashop_languages
              current_lang=$prestashop_lang
              input_name="EPAYNC_FULLCB_TITLE"
              input_value=$EPAYNC_FULLCB_TITLE
              style="width: 330px;"
            }
            <p>{l s='Method title to display on payment means page.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='RESTRICTIONS' mod='epaync'}</legend>

          <div id="EPAYNC_FULLCB_COUNTRY_MENU">
            <input type="hidden" name ="EPAYNC_FULLCB_COUNTRY" value="1">
            <input type="hidden" name ="EPAYNC_FULLCB_COUNTRY_LST[]" value ="FR">
            <label for="EPAYNC_FULLCB_COUNTRY_LST">{l s='Authorized countries' mod='epaync'}</label>
            <div class="margin-form">
              <span style="font-size: 13px; padding-top: 5px; vertical-align: middle;"><b>{$epaync_countries_list['ps_countries']['FR']|escape:'html':'UTF-8'}</b></span>
            </div>
          </div>

          <label>{l s='Customer group amount restriction' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./table_amount_group.tpl"
              groups=$prestashop_groups
              input_name="EPAYNC_FULLCB_AMOUNTS"
              input_value=$EPAYNC_FULLCB_AMOUNTS
            }
            <p>{l s='Define amount restriction for each customer group.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='PAYMENT OPTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_FULLCB_ENABLE_OPTS">{l s='Enable options selection' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_FULLCB_ENABLE_OPTS" name="EPAYNC_FULLCB_ENABLE_OPTS" onchange="javascript: epayncFullcbEnableOptionsChanged();">
              {foreach from=$epaync_yes_no_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_FULLCB_ENABLE_OPTS === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Enable payment options selection on merchant site.' mod='epaync'}</p>
          </div>

          <section id="epaync_fullcb_options_settings">
            <label>{l s='Payment options' mod='epaync'}</label>
            <div class="margin-form">
              <table class="table" cellpadding="10" cellspacing="0">
                <thead>
                  <tr>
                    <th style="font-size: 10px;">{l s='Activation' mod='epaync'}</th>
                    <th style="font-size: 10px;">{l s='Label' mod='epaync'}</th>
                    <th style="font-size: 10px;">{l s='Min amount' mod='epaync'}</th>
                    <th style="font-size: 10px;">{l s='Max amount' mod='epaync'}</th>
                    <th style="font-size: 10px;">{l s='Rate' mod='epaync'}</th>
                    <th style="font-size: 10px;">{l s='Cap' mod='epaync'}</th>
                  </tr>
                </thead>

                <tbody>
                  {foreach from=$EPAYNC_FULLCB_OPTIONS key="key" item="option"}
                  <tr>
                    <td>
                      <input name="EPAYNC_FULLCB_OPTIONS[{$key|escape:'html':'UTF-8'}][enabled]"
                        style="width: 100%;"
                        type="checkbox"
                        value="True"
                        {if !isset($option.enabled) || ($option.enabled === 'True')}checked{/if}>
                    </td>
                    <td>
                      {include file="./input_text_lang.tpl"
                        languages=$prestashop_languages
                        current_lang=$prestashop_lang
                        input_name="EPAYNC_FULLCB_OPTIONS[{$key|escape:'html':'UTF-8'}][label]"
                        field_id="EPAYNC_FULLCB_OPTIONS_{$key|escape:'html':'UTF-8'}_label"
                        input_value=$option['label']
                        style="width: 140px;"
                      }
                      <input name="EPAYNC_FULLCB_OPTIONS[{$key|escape:'html':'UTF-8'}][count]" value="{$option['count']|escape:'html':'UTF-8'}" type="text" style="display: none; width: 0px;">
                    </td>
                    <td>
                      <input name="EPAYNC_FULLCB_OPTIONS[{$key|escape:'html':'UTF-8'}][min_amount]"
                        value="{if isset($option)}{$option['min_amount']|escape:'html':'UTF-8'}{/if}"
                        style="width: 75px;"
                        type="text">
                    </td>
                    <td>
                      <input name="EPAYNC_FULLCB_OPTIONS[{$key|escape:'html':'UTF-8'}][max_amount]"
                        value="{if isset($option)}{$option['max_amount']|escape:'html':'UTF-8'}{/if}"
                        style="width: 75px;"
                        type="text">
                    </td>
                    <td>
                      <input name="EPAYNC_FULLCB_OPTIONS[{$key|escape:'html':'UTF-8'}][rate]"
                        value="{if isset($option)}{$option['rate']|escape:'html':'UTF-8'}{/if}"
                        style="width: 70px;"
                        type="text">
                    </td>
                    <td>
                      <input name="EPAYNC_FULLCB_OPTIONS[{$key|escape:'html':'UTF-8'}][cap]"
                        value="{if isset($option)}{$option['cap']|escape:'html':'UTF-8'}{/if}"
                        style="width: 70px;"
                        type="text">
                    </td>
                  </tr>
                  {/foreach}
                </tbody>
              </table>
              <p>
                {l s='Configure FullCB payment options.' mod='epaync'}<br />
                <b>{l s='Activation' mod='epaync'} : </b>{l s='Enable / disable the payment option.' mod='epaync'}<br />
                <b>{l s='Min amount' mod='epaync'} : </b>{l s='Minimum amount to enable the payment option.' mod='epaync'}<br />
                <b>{l s='Max amount' mod='epaync'} : </b>{l s='Maximum amount to enable the payment option.' mod='epaync'}<br />
                <b>{l s='Rate' mod='epaync'} : </b>{l s='The interest rate in percentage.' mod='epaync'}<br />
                <b>{l s='Cap' mod='epaync'} : </b>{l s='Maximum fees amount of payment option.' mod='epaync'}<br />
                <b>{l s='Do not forget to click on « Save » button to save your modifications.' mod='epaync'}</b>
              </p>
            </div>
          </section>

          <script type="text/javascript">
            epayncFullcbEnableOptionsChanged();
          </script>
         </fieldset>
        <div class="clear">&nbsp;</div>
      </div>
    {/if}

    {if $epaync_plugin_features['ancv']}
      <h4 style="font-weight: bold; margin-bottom: 0; overflow: hidden; line-height: unset !important;">
        <a href="#">{l s='ANCV PAYMENT' mod='epaync'}</a>
      </h4>
      <div>
        <fieldset>
          <legend>{l s='MODULE OPTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_ANCV_ENABLED">{l s='Activation' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_ANCV_ENABLED" name="EPAYNC_ANCV_ENABLED">
              {foreach from=$epaync_enable_disable_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_ANCV_ENABLED === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Enables / disables this payment method.' mod='epaync'}</p>
          </div>

          <label>{l s='Payment method title' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./input_text_lang.tpl"
              languages=$prestashop_languages
              current_lang=$prestashop_lang
              input_name="EPAYNC_ANCV_TITLE"
              input_value=$EPAYNC_ANCV_TITLE
              style="width: 330px;"
            }
            <p>{l s='Method title to display on payment means page.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='RESTRICTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_ANCV_COUNTRY">{l s='Restrict to some countries' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_ANCV_COUNTRY" name="EPAYNC_ANCV_COUNTRY" onchange="javascript: epayncCountriesRestrictMenuDisplay('EPAYNC_ANCV_COUNTRY')">
              {foreach from=$epaync_countries_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_ANCV_COUNTRY === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Buyer\'s billing countries in which this payment method is available.' mod='epaync'}</p>
          </div>

          <div id="EPAYNC_ANCV_COUNTRY_MENU" {if $EPAYNC_ANCV_COUNTRY === '1'} style="display: none;"{/if}>
            <label for="EPAYNC_ANCV_COUNTRY_LST">{l s='Authorized countries' mod='epaync'}</label>
            <div class="margin-form">
              <select id="EPAYNC_ANCV_COUNTRY_LST" name="EPAYNC_ANCV_COUNTRY_LST[]" multiple="multiple" size="7">
                {foreach from=$epaync_countries_list['ps_countries'] key="key" item="option"}
                  <option value="{$key|escape:'html':'UTF-8'}"{if in_array($key, $EPAYNC_ANCV_COUNTRY_LST)} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                {/foreach}
              </select>
            </div>
          </div>

          <label>{l s='Customer group amount restriction' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./table_amount_group.tpl"
              groups=$prestashop_groups
              input_name="EPAYNC_ANCV_AMOUNTS"
              input_value=$EPAYNC_ANCV_AMOUNTS
            }
            <p>{l s='Define amount restriction for each customer group.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='PAYMENT PAGE' mod='epaync'}</legend>

          <label for="EPAYNC_ANCV_DELAY">{l s='Capture delay' mod='epaync'}</label>
          <div class="margin-form">
            <input id="EPAYNC_ANCV_DELAY" name="EPAYNC_ANCV_DELAY" value="{$EPAYNC_ANCV_DELAY|escape:'html':'UTF-8'}" type="text">
            <p>{l s='The number of days before the bank capture. Enter value only if different from « Base settings ».' mod='epaync'}</p>
          </div>

          <label for="EPAYNC_ANCV_VALIDATION">{l s='Validation mode' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_ANCV_VALIDATION" name="EPAYNC_ANCV_VALIDATION">
              <option value="-1"{if $EPAYNC_ANCV_VALIDATION === '-1'} selected="selected"{/if}>{l s='Base settings configuration' mod='epaync'}</option>
              {foreach from=$epaync_validation_mode_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_ANCV_VALIDATION === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='If manual is selected, you will have to confirm payments manually in your bank Back Office.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>
      </div>
    {/if}

    {if $epaync_plugin_features['sepa']}
      <h4 style="font-weight: bold; margin-bottom: 0; overflow: hidden; line-height: unset !important;">
        <a href="#">{l s='SEPA PAYMENT' mod='epaync'}</a>
      </h4>
      <div>
        <fieldset>
          <legend>{l s='MODULE OPTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_SEPA_ENABLED">{l s='Activation' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_SEPA_ENABLED" name="EPAYNC_SEPA_ENABLED">
              {foreach from=$epaync_enable_disable_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_SEPA_ENABLED === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Enables / disables this payment method.' mod='epaync'}</p>
          </div>

          <label>{l s='Payment method title' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./input_text_lang.tpl"
              languages=$prestashop_languages
              current_lang=$prestashop_lang
              input_name="EPAYNC_SEPA_TITLE"
              input_value=$EPAYNC_SEPA_TITLE
              style="width: 330px;"
            }
            <p>{l s='Method title to display on payment means page.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='RESTRICTIONS' mod='epaync'}</legend>

          {if isset ($epaync_countries_list['SEPA'])}
            <label for="EPAYNC_SEPA_COUNTRY">{l s='Restrict to some countries' mod='epaync'}</label>
            <div class="margin-form">
              <select id="EPAYNC_SEPA_COUNTRY" name="EPAYNC_SEPA_COUNTRY" onchange="javascript: epayncCountriesRestrictMenuDisplay('EPAYNC_SEPA_COUNTRY')">
                {foreach from=$epaync_countries_options key="key" item="option"}
                  <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_SEPA_COUNTRY === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                {/foreach}
              </select>
              <p>{l s='Buyer\'s billing countries in which this payment method is available.' mod='epaync'}</p>
            </div>

            <div id="EPAYNC_SEPA_COUNTRY_MENU" {if $EPAYNC_SEPA_COUNTRY === '1'} style="display: none;"{/if}>
              <label for="EPAYNC_SEPA_COUNTRY_LST">{l s='Authorized countries' mod='epaync'}</label>
              <div class="margin-form">
                <select id="EPAYNC_SEPA_COUNTRY_LST" name="EPAYNC_SEPA_COUNTRY_LST[]" multiple="multiple" size="7">
                  {if isset ($epaync_countries_list['SEPA'])}
                      {foreach from=$epaync_countries_list['SEPA'] key="key" item="option"}
                          <option value="{$key|escape:'html':'UTF-8'}"{if in_array($key, $EPAYNC_SEPA_COUNTRY_LST)} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                      {/foreach}
                  {/if}
                </select>
              </div>
            </div>
          {else}
            <input type="hidden" name ="EPAYNC_SEPA_COUNTRY" value="1">
            <input type="hidden" name ="EPAYNC_SEPA_COUNTRY_LST[]" value ="">
            <p style="background: none repeat scroll 0 0 #FFFFE0; border: 1px solid #E6DB55; font-size: 13px; margin: 0 0 20px; padding: 10px;">
                {l s='Payment method unavailable for the list of countries defined on your PrestaShop store.' mod='epaync'}
            </p>
          {/if}

          <label>{l s='Customer group amount restriction' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./table_amount_group.tpl"
              groups=$prestashop_groups
              input_name="EPAYNC_SEPA_AMOUNTS"
              input_value=$EPAYNC_SEPA_AMOUNTS
            }
            <p>{l s='Define amount restriction for each customer group.' mod='epaync'}</p>
          </div>
         </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='PAYMENT PAGE' mod='epaync'}</legend>

          <label for="EPAYNC_SEPA_DELAY">{l s='Capture delay' mod='epaync'}</label>
          <div class="margin-form">
            <input id="EPAYNC_SEPA_DELAY" name="EPAYNC_SEPA_DELAY" value="{$EPAYNC_SEPA_DELAY|escape:'html':'UTF-8'}" type="text">
            <p>{l s='The number of days before the bank capture. Enter value only if different from « Base settings ».' mod='epaync'}</p>
          </div>

          <label for="EPAYNC_SEPA_VALIDATION">{l s='Validation mode' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_SEPA_VALIDATION" name="EPAYNC_SEPA_VALIDATION">
              <option value="-1"{if $EPAYNC_SEPA_VALIDATION === '-1'} selected="selected"{/if}>{l s='Base settings configuration' mod='epaync'}</option>
              {foreach from=$epaync_validation_mode_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_SEPA_VALIDATION === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='If manual is selected, you will have to confirm payments manually in your bank Back Office.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='PAYMENT OPTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_SEPA_MANDATE_MODE">{l s='SEPA direct debit mode' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_SEPA_MANDATE_MODE" name="EPAYNC_SEPA_MANDATE_MODE" onchange="javascript: epayncSepa1clickPaymentMenuDisplay('EPAYNC_SEPA_MANDATE_MODE')">
              {foreach from=$epaync_sepa_mandate_mode_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_SEPA_MANDATE_MODE === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Select SEPA direct debit mode. Attention, the two last choices require the payment by token option on %s.' sprintf='EpayNC' mod='epaync'}</p>
          </div>

          <div id="EPAYNC_SEPA_1_CLICK_PAYMNT_MENU"  {if $EPAYNC_SEPA_MANDATE_MODE !== 'REGISTER_PAY'} style="display: none;"{/if}>
            <label for="EPAYNC_SEPA_1_CLICK_PAYMNT">{l s='1-Click payment' mod='epaync'}</label>
            <div class="margin-form">
              <select id="EPAYNC_SEPA_1_CLICK_PAYMNT" name="EPAYNC_SEPA_1_CLICK_PAYMNT">
                {foreach from=$epaync_yes_no_options key="key" item="option"}
                  <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_SEPA_1_CLICK_PAYMNT === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                {/foreach}
              </select>
              <p>{l s='This option allows to pay orders without re-entering bank data at each payment. The "payment by token" option should be enabled on your %s store to use this feature.' sprintf='EpayNC' mod='epaync'}</p>
            </div>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>
      </div>
    {/if}

    {if $epaync_plugin_features['paypal']}
      <h4 style="font-weight: bold; margin-bottom: 0; overflow: hidden; line-height: unset !important;">
        <a href="#">{l s='PAYPAL PAYMENT' mod='epaync'}</a>
      </h4>
      <div>
        <fieldset>
          <legend>{l s='MODULE OPTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_PAYPAL_ENABLED">{l s='Activation' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_PAYPAL_ENABLED" name="EPAYNC_PAYPAL_ENABLED">
              {foreach from=$epaync_enable_disable_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_PAYPAL_ENABLED === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Enables / disables this payment method.' mod='epaync'}</p>
          </div>

          <label>{l s='Payment method title' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./input_text_lang.tpl"
              languages=$prestashop_languages
              current_lang=$prestashop_lang
              input_name="EPAYNC_PAYPAL_TITLE"
              input_value=$EPAYNC_PAYPAL_TITLE
              style="width: 330px;"
            }
            <p>{l s='Method title to display on payment means page.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='RESTRICTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_PAYPAL_COUNTRY">{l s='Restrict to some countries' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_PAYPAL_COUNTRY" name="EPAYNC_PAYPAL_COUNTRY" onchange="javascript: epayncCountriesRestrictMenuDisplay('EPAYNC_PAYPAL_COUNTRY')">
              {foreach from=$epaync_countries_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_PAYPAL_COUNTRY === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Buyer\'s billing countries in which this payment method is available.' mod='epaync'}</p>
          </div>

          <div id="EPAYNC_PAYPAL_COUNTRY_MENU" {if $EPAYNC_PAYPAL_COUNTRY === '1'} style="display: none;"{/if}>
            <label for="EPAYNC_PAYPAL_COUNTRY_LST">{l s='Authorized countries' mod='epaync'}</label>
            <div class="margin-form">
              <select id="EPAYNC_PAYPAL_COUNTRY_LST" name="EPAYNC_PAYPAL_COUNTRY_LST[]" multiple="multiple" size="7">
                {foreach from=$epaync_countries_list['ps_countries'] key="key" item="option"}
                  <option value="{$key|escape:'html':'UTF-8'}"{if in_array($key, $EPAYNC_PAYPAL_COUNTRY_LST)} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                {/foreach}
              </select>
            </div>
          </div>

          <label>{l s='Customer group amount restriction' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./table_amount_group.tpl"
              groups=$prestashop_groups
              input_name="EPAYNC_PAYPAL_AMOUNTS"
              input_value=$EPAYNC_PAYPAL_AMOUNTS
            }
            <p>{l s='Define amount restriction for each customer group.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='PAYMENT PAGE' mod='epaync'}</legend>

          <label for="EPAYNC_PAYPAL_DELAY">{l s='Capture delay' mod='epaync'}</label>
          <div class="margin-form">
            <input id="EPAYNC_PAYPAL_DELAY" name="EPAYNC_PAYPAL_DELAY" value="{$EPAYNC_PAYPAL_DELAY|escape:'html':'UTF-8'}" type="text">
            <p>{l s='The number of days before the bank capture. Enter value only if different from « Base settings ».' mod='epaync'}</p>
          </div>

          <label for="EPAYNC_PAYPAL_VALIDATION">{l s='Validation mode' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_PAYPAL_VALIDATION" name="EPAYNC_PAYPAL_VALIDATION">
              <option value="-1"{if $EPAYNC_PAYPAL_VALIDATION === '-1'} selected="selected"{/if}>{l s='Base settings configuration' mod='epaync'}</option>
              {foreach from=$epaync_validation_mode_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_PAYPAL_VALIDATION === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='If manual is selected, you will have to confirm payments manually in your bank Back Office.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>
      </div>
    {/if}

    {if $epaync_plugin_features['sofort']}
      <h4 style="font-weight: bold; margin-bottom: 0; overflow: hidden; line-height: unset !important;">
        <a href="#">{l s='SOFORT BANKING PAYMENT' mod='epaync'}</a>
      </h4>
      <div>
        <fieldset>
          <legend>{l s='MODULE OPTIONS' mod='epaync'}</legend>

          <label for="EPAYNC_SOFORT_ENABLED">{l s='Activation' mod='epaync'}</label>
          <div class="margin-form">
            <select id="EPAYNC_SOFORT_ENABLED" name="EPAYNC_SOFORT_ENABLED">
              {foreach from=$epaync_enable_disable_options key="key" item="option"}
                <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_SOFORT_ENABLED === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
              {/foreach}
            </select>
            <p>{l s='Enables / disables this payment method.' mod='epaync'}</p>
          </div>

          <label>{l s='Payment method title' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./input_text_lang.tpl"
              languages=$prestashop_languages
              current_lang=$prestashop_lang
              input_name="EPAYNC_SOFORT_TITLE"
              input_value=$EPAYNC_SOFORT_TITLE
              style="width: 330px;"
            }
            <p>{l s='Method title to display on payment means page.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>

        <fieldset>
          <legend>{l s='RESTRICTIONS' mod='epaync'}</legend>

          {if isset ($epaync_countries_list['SOFORT'])}
            <label for="EPAYNC_SOFORT_COUNTRY">{l s='Restrict to some countries' mod='epaync'}</label>
            <div class="margin-form">
              <select id="EPAYNC_SOFORT_COUNTRY" name="EPAYNC_SOFORT_COUNTRY" onchange="javascript: epayncCountriesRestrictMenuDisplay('EPAYNC_SOFORT_COUNTRY')">
                {foreach from=$epaync_countries_options key="key" item="option"}
                  <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_SOFORT_COUNTRY === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                {/foreach}
              </select>
              <p>{l s='Buyer\'s billing countries in which this payment method is available.' mod='epaync'}</p>
            </div>

            <div id="EPAYNC_SOFORT_COUNTRY_MENU" {if $EPAYNC_SOFORT_COUNTRY === '1'} style="display: none;"{/if}>
              <label for="EPAYNC_SOFORT_COUNTRY_LST">{l s='Authorized countries' mod='epaync'}</label>
              <div class="margin-form">
                <select id="EPAYNC_SOFORT_COUNTRY_LST" name="EPAYNC_SOFORT_COUNTRY_LST[]" multiple="multiple" size="7">
                  {if isset ($epaync_countries_list['SOFORT'])}
                      {foreach from=$epaync_countries_list['SOFORT'] key="key" item="option"}
                          <option value="{$key|escape:'html':'UTF-8'}"{if in_array($key, $EPAYNC_SOFORT_COUNTRY_LST)} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
                      {/foreach}
                  {/if}
                </select>
              </div>
            </div>
          {else}
            <input type="hidden" name ="EPAYNC_SOFORT_COUNTRY" value="1">
            <input type="hidden" name ="EPAYNC_SOFORT_COUNTRY_LST[]" value ="">
            <p style="background: none repeat scroll 0 0 #FFFFE0; border: 1px solid #E6DB55; font-size: 13px; margin: 0 0 20px; padding: 10px;">
                {l s='Payment method unavailable for the list of countries defined on your PrestaShop store.' mod='epaync'}
            </p>
          {/if}

          <label>{l s='Customer group amount restriction' mod='epaync'}</label>
          <div class="margin-form">
            {include file="./table_amount_group.tpl"
              groups=$prestashop_groups
              input_name="EPAYNC_SOFORT_AMOUNTS"
              input_value=$EPAYNC_SOFORT_AMOUNTS
            }
            <p>{l s='Define amount restriction for each customer group.' mod='epaync'}</p>
          </div>
        </fieldset>
        <div class="clear">&nbsp;</div>
      </div>
    {/if}

    <h4 style="font-weight: bold; margin-bottom: 0; overflow: hidden; line-height: unset !important;">
      <a href="#">{l s='OTHER PAYMENT MEANS' mod='epaync'}</a>
    </h4>
    <div>
      <fieldset>
        <legend>{l s='MODULE OPTIONS' mod='epaync'}</legend>

        <label for="EPAYNC_OTHER_ENABLED">{l s='Activation' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_OTHER_ENABLED" name="EPAYNC_OTHER_ENABLED">
            {foreach from=$epaync_enable_disable_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_OTHER_ENABLED === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <p>{l s='Enables / disables this payment method.' mod='epaync'}</p>
        </div>

        <label>{l s='Payment method title' mod='epaync'}</label>
        <div class="margin-form">
          {include file="./input_text_lang.tpl"
            languages=$prestashop_languages
            current_lang=$prestashop_lang
            input_name="EPAYNC_OTHER_TITLE"
            input_value=$EPAYNC_OTHER_TITLE
            style="width: 330px;"
          }
          <p>{l s='Method title to display on payment means page. Used only if « Regroup payment means » option is enabled.' mod='epaync'}</p>
        </div>
      </fieldset>
      <div class="clear">&nbsp;</div>

      <fieldset>
        <legend>{l s='RESTRICTIONS' mod='epaync'}</legend>

        <label for="EPAYNC_OTHER_COUNTRY">{l s='Restrict to some countries' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_OTHER_COUNTRY" name="EPAYNC_OTHER_COUNTRY" onchange="javascript: epayncCountriesRestrictMenuDisplay('EPAYNC_OTHER_COUNTRY')">
            {foreach from=$epaync_countries_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_OTHER_COUNTRY === (string)$key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <p>{l s='Buyer\'s billing countries in which this payment method is available.' mod='epaync'}</p>
        </div>

        <div id="EPAYNC_OTHER_COUNTRY_MENU" {if $EPAYNC_OTHER_COUNTRY === '1'} style="display: none;"{/if}>
        <label for="EPAYNC_OTHER_COUNTRY_LST">{l s='Authorized countries' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_OTHER_COUNTRY_LST" name="EPAYNC_OTHER_COUNTRY_LST[]" multiple="multiple" size="7">
            {foreach from=$epaync_countries_list['ps_countries'] key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if in_array($key, $EPAYNC_OTHER_COUNTRY_LST)} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
        </div>
        </div>

        <label>{l s='Customer group amount restriction' mod='epaync'}</label>
        <div class="margin-form">
          {include file="./table_amount_group.tpl"
            groups=$prestashop_groups
            input_name="EPAYNC_OTHER_AMOUNTS"
            input_value=$EPAYNC_OTHER_AMOUNTS
          }
          <p>{l s='Define amount restriction for each customer group.' mod='epaync'}</p>
        </div>
      </fieldset>
      <div class="clear epaync-grouped">&nbsp;</div>

      <fieldset>
        <legend>{l s='PAYMENT OPTIONS' mod='epaync'}</legend>

        <label for="EPAYNC_OTHER_GROUPED_VIEW">{l s='Regroup payment means ' mod='epaync'}</label>
        <div class="margin-form">
          <select id="EPAYNC_OTHER_GROUPED_VIEW" name="EPAYNC_OTHER_GROUPED_VIEW" onchange="javascript: epayncGroupedViewChanged();">
            {foreach from=$epaync_enable_disable_options key="key" item="option"}
              <option value="{$key|escape:'html':'UTF-8'}"{if $EPAYNC_OTHER_GROUPED_VIEW === $key} selected="selected"{/if}>{$option|escape:'html':'UTF-8'}</option>
            {/foreach}
          </select>
          <p>{l s='If this option is enabled, all the payment means added in this section will be displayed within the same payment submodule.' mod='epaync'}</p>
        </div>

        <label>{l s='Payment means' mod='epaync'}</label>
        <div class="margin-form">
          {assign var=merged_array_cards value=$epaync_payment_cards_options}
          {assign var=VALID_EPAYNC_EXTRA_PAYMENT_MEANS value=[]}
          {foreach from=$EPAYNC_EXTRA_PAYMENT_MEANS key="key_card" item="option_card"}
              {if ! isset($merged_array_cards[$option_card.code])}
                  {append var='merged_array_cards' value=$option_card.title index=$option_card.code}
                  {$VALID_EPAYNC_EXTRA_PAYMENT_MEANS.$key_card = $option_card}
              {/if}
          {/foreach}

          <script type="text/html" id="epaync_other_payment_means_row_option">
            {include file="./row_other_payment_means_option.tpl"
              payment_means_cards=$merged_array_cards
              countries_list=$epaync_countries_list['ps_countries']
              validation_mode_options=$epaync_validation_mode_options
              enable_disable_options=$epaync_enable_disable_options
              languages=$prestashop_languages
              current_lang=$prestashop_lang
              key="EPAYNC_OTHER_PAYMENT_SCRIPT_MEANS_KEY"
              option=$epaync_default_other_payment_means_option
            }
          </script>

          <button type="button" id="epaync_other_payment_means_options_btn"{if !empty($EPAYNC_OTHER_PAYMENT_MEANS)} style="display: none;"{/if} onclick="javascript: epayncAddOtherPaymentMeansOption(true, '{l s='Delete' mod='epaync'}');">{l s='Add' mod='epaync'}</button>

          <table id="epaync_other_payment_means_options_table"{if empty($EPAYNC_OTHER_PAYMENT_MEANS)} style="display: none;"{/if} class="table" cellpadding="10" cellspacing="0">
          <thead>
            <tr>
              <th style="font-size: 10px;">{l s='Label' mod='epaync'}</th>
              <th style="font-size: 10px;">{l s='Means of payment' mod='epaync'}</th>
              <th style="font-size: 10px;">{l s='Countries' mod='epaync'}</th>
              <th style="font-size: 10px;">{l s='Min amount' mod='epaync'}</th>
              <th style="font-size: 10px;">{l s='Max amount' mod='epaync'}</th>
              <th style="font-size: 10px;">{l s='Capture' mod='epaync'}</th>
              <th style="font-size: 10px;">{l s='Validation mode' mod='epaync'}</th>
              <th style="font-size: 10px;">{l s='Cart data' mod='epaync'}</th>
              <th style="font-size: 10px;"></th>
            </tr>
          </thead>

          <tbody>
            {foreach from=$EPAYNC_OTHER_PAYMENT_MEANS key="key" item="option"}
              {include file="./row_other_payment_means_option.tpl"
                payment_means_cards=$merged_array_cards
                countries_list=$epaync_countries_list['ps_countries']
                validation_mode_options=$epaync_validation_mode_options
                enable_disable_options=$epaync_enable_disable_options
                languages=$prestashop_languages
                current_lang=$prestashop_lang
                key=$key
                option=$option
              }
            {/foreach}

            <tr id="epaync_other_payment_means_option_add">
              <td colspan="8"></td>
              <td>
                <button type="button" onclick="javascript: epayncAddOtherPaymentMeansOption(false, '{l s='Delete' mod='epaync'}');">{l s='Add' mod='epaync'}</button>
              </td>
            </tr>
          </tbody>
          </table>

          {if empty($EPAYNC_OTHER_PAYMENT_MEANS)}
            <input type="hidden" id="EPAYNC_OTHER_PAYMENT_MEANS" name="EPAYNC_OTHER_PAYMENT_MEANS" value="">
          {/if}

          <p>
            {l s='Click on « Add » button to configure one or more payment means.' mod='epaync'}<br />
            <b>{l s='Label' mod='epaync'} : </b>{l s='The label of the means of payment to display on your site.' mod='epaync'}<br />
            <b>{l s='Means of payment' mod='epaync'} : </b>{l s='Choose the means of payment you want to propose.' mod='epaync'}<br />
            <b>{l s='Countries' mod='epaync'} : </b>{l s='Countries where the means of payment will be available. Keep blank to authorize all countries.' mod='epaync'}<br />
            <b>{l s='Min amount' mod='epaync'} : </b>{l s='Minimum amount to enable the means of payment.' mod='epaync'}<br />
            <b>{l s='Max amount' mod='epaync'} : </b>{l s='Maximum amount to enable the means of payment.' mod='epaync'}<br />
            <b>{l s='Capture' mod='epaync'} : </b>{l s='The number of days before the bank capture. Enter value only if different from « Base settings ».' mod='epaync'}<br />
            <b>{l s='Validation mode' mod='epaync'} : </b>{l s='If manual is selected, you will have to confirm payments manually in your bank Back Office.' mod='epaync'}<br />
            <b>{l s='Cart data' mod='epaync'} : </b>{l s='If you disable this option, the shopping cart details will not be sent to the gateway. Attention, in some cases, this option has to be enabled. For more information, refer to the module documentation.' mod='epaync'}<br />
            <b>{l s='Do not forget to click on « Save » button to save your modifications.' mod='epaync'}</b>
          </p>
        </div>

        <label>{l s='Add payment means' mod='epaync'}</label>
        <div class="margin-form">
          <script type="text/html" id="epaync_add_payment_means_row_option">
            {include file="./row_extra_means_of_payment.tpl"
              key="EPAYNC_EXTRA_PAYMENT_MEANS_SCRIPT_KEY"
              option=$epaync_default_extra_payment_means_option
            }
          </script>

          <button type="button" id="epaync_extra_payment_means_options_btn"{if !empty($VALID_EPAYNC_EXTRA_PAYMENT_MEANS)} style="display: none;"{/if} onclick="javascript: epayncAddExtraPaymentMeansOption(true, '{l s='Delete' mod='epaync'}');">{l s='Add' mod='epaync'}</button>

          <table id="epaync_extra_payment_means_options_table"{if empty($VALID_EPAYNC_EXTRA_PAYMENT_MEANS)} style="display: none;"{/if} class="table" cellpadding="10" cellspacing="0">
          <thead>
            <tr>
              <th style="font-size: 10px;">{l s='Code' mod='epaync'}</th>
              <th style="font-size: 10px; width: 350px;">{l s='Label' mod='epaync'}</th>
              <th style="font-size: 10px;">{l s='Action' mod='epaync'}</th>
            </tr>
          </thead>

          <tbody>
            {foreach from=$VALID_EPAYNC_EXTRA_PAYMENT_MEANS key="key" item="option"}
                {include file="./row_extra_means_of_payment.tpl"
                    key=$key
                    option=$option
                }
            {/foreach}

            <tr id="epaync_extra_payment_means_option_add">
              <td colspan="2"></td>
              <td>
                <button type="button" onclick="javascript: epayncAddExtraPaymentMeansOption(false, '{l s='Delete' mod='epaync'}');">{l s='Add' mod='epaync'}</button>
              </td>
            </tr>
          </tbody>
          </table>

          {if empty($VALID_EPAYNC_EXTRA_PAYMENT_MEANS)}
            <input type="hidden" id="EPAYNC_EXTRA_PAYMENT_MEANS" name="EPAYNC_EXTRA_PAYMENT_MEANS" value="">
          {/if}

          <p>
            {l s='Click on « Add » button to add one or more new payment means.' mod='epaync'}<br />
            <b>{l s='Code' mod='epaync'} : </b>{l s='The code of the means of payment as expected by %s gateway.' sprintf='EpayNC' mod='epaync'}<br />
            <b>{l s='Label' mod='epaync'} : </b>{l s='The default label of the means of payment.' mod='epaync'}<br />
            <b>{l s='Do not forget to click on « Save » button to save your modifications.' mod='epaync'}</b>
          </p>
        </div>
      </fieldset>
      <div class="clear">&nbsp;</div>
    </div>

   </div>

  {if version_compare($smarty.const._PS_VERSION_, '1.6', '<')}
    <div class="clear" style="width: 100%;">
      <input type="submit" class="button" name="epaync_submit_admin_form" value="{l s='Save' mod='epaync'}" style="float: right;">
    </div>
  {else}
    <div class="panel-footer" style="width: 100%;">
      <button type="submit" value="1" name="epaync_submit_admin_form" class="btn btn-default pull-right" style="float: right !important;">
        <i class="process-icon-save"></i>
        {l s='Save' mod='epaync'}
      </button>
    </div>
  {/if}
</form>

<br />
<br />