{**
 * Copyright © Lyra Network.
 * This file is part of EpayNC plugin for PrestaShop. See COPYING.md for license details.
 *
 * @author    Lyra Network (https://www.lyra.com/)
 * @copyright Lyra Network
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *}

<script>
    // Add refund checkboxes for PrestaShop >= 1.7.7.
    $(function() {
        var epayncRefund = "{l s='Refund the buyer by Web Services with %s' sprintf='EpayNC' mod='epaync'}";

        // Create EpayNC partial refund checkbox.
        if ($('#doPartialRefundEpaync').length === 0) {
            var newCheckbox = '\
                    <div class="cancel-product-element epaync-refund epaync-partial-refund form-group" style="display: block;">\
                        <div class="checkbox">\
                            <div class="md-checkbox md-checkbox-inline">\
                                <label>\
                                    <input type="checkbox" id="doPartialRefundEpaync" name="doPartialRefundEpaync" material_design="material_design" value="1">\
                                      <i class="md-checkbox-control"></i>' +
                                        epayncRefund + '\
                                </label>\
                            </div>\
                        </div>\
                    </div>';

                $(newCheckbox).insertAfter('.refund-checkboxes-container .refund-voucher');
            }

            // Create EpayNC standard refund checkbox.
            if ($('#doStandardRefundEpaync').length === 0) {
                var newCheckbox = '\
                    <div class="cancel-product-element epaync-refund epaync-standard-refund form-group" style="display: block;">\
                        <div class="checkbox">\
                            <div class="md-checkbox md-checkbox-inline">\
                                <label>\
                                    <input type="checkbox" id="doStandardRefundEpaync" name="doStandardRefundEpaync" material_design="material_design" value="1">\
                                      <i class="md-checkbox-control"></i>' +
                                        epayncRefund + '\
                                </label>\
                            </div>\
                        </div>\
                    </div>';

                $(newCheckbox).insertAfter('.refund-checkboxes-container .refund-voucher');
            }
        });

        $(document).on('click', '.partial-refund-display', function() {
            $('.epaync-standard-refund').hide();
        });

        $(document).on('click', '.standard-refund-display', function() {
            $('.epaync-partial-refund').hide();
        });

        // Click on credit slip creation checkbox.
        $(document).on('click', '#cancel_product_credit_slip', function() {
            toggleCheckboxDisplay();
        });

        // Click on voucher creation checkbox.
        $(document).on('click', '#cancel_product_voucher', function() {
            toggleCheckboxDisplay();
        });

        // Do not allow refund if no credit slip is generated or if a voucher is generated.
        function toggleCheckboxDisplay() {
            $('.epaync-refund input').attr('disabled', 'disabled');
            $('.epaync-refund').hide();

            if ($('#cancel_product_credit_slip').is(':checked')
                && ! $('#cancel_product_voucher').is(':checked')) {
                if ($('.shipping-refund').is(":visible") == true) {
                    $('#doStandardRefundEpaync').removeAttr('disabled');
                    $('.epaync-standard-refund').show();
                } else {
                    $('#doPartialRefundEpaync').removeAttr('disabled');
                    $('.epaync-partial-refund').show();
                }
            }
        }
</script>