{**
 * Copyright © Lyra Network.
 * This file is part of EpayNC plugin for PrestaShop. See COPYING.md for license details.
 *
 * @author    Lyra Network (https://www.lyra.com/)
 * @copyright Lyra Network
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *}

<script>
    // Add refund checkboxes for PrestaShop < 1.7.7.
    $(function() {
        var epayncRefund = "{l s='Refund the buyer by Web Services with %s' sprintf='EpayNC' mod='epaync'}";

        // Create EpayNC partial refund checkbox.
        if ($('#doPartialRefundEpaync').length === 0) {
            var newCheckbox = '<p class="checkbox epaync-partial-refund">\
                                   <label for="doPartialRefundEpaync">\
                                       <input type="checkbox" id="doPartialRefundEpaync" name="doPartialRefundEpaync" value="1">' +
                                           epayncRefund + '\
                                   </label>\
                               </p>';

            $(newCheckbox).insertAfter($('#generateDiscountRefund').parent().parent());
        }

        // Create EpayNC standard refund checkbox.
        if ($('#doStandardRefundEpaync').length === 0) {
            var newCheckbox = '<p class="checkbox epaync-standard-refund" style="display: none;">\
                                   <label for="doStandardRefundEpaync">\
                                       <input type="checkbox" id="doStandardRefundEpaync" name="doStandardRefundEpaync" value="1">' +
                                           epayncRefund + '\
                                   </label>\
                                </p>';
            $(newCheckbox).insertAfter($('#generateDiscount').parent().parent());
        }
    });

    // Click on credit slip creation checkbox, standard payment.
    $(document).on('click', '#generateCreditSlip', function() {
        toggleStandardCheckboxDisplay();
    });

    // Click on voucher creation checkbox, standard payment.
    $(document).on('click', '#generateDiscount', function() {
        toggleStandardCheckboxDisplay();
    });

    // Click on voucher creation checkbox, partial payment.
    $(document).on('click', '#generateDiscountRefund', function() {
        if ($('#generateDiscountRefund').is(':checked')) {
            $('.epaync-partial-refund input').attr('disabled', 'disabled');
            $('.epaync-partial-refund').hide();
        } else {
            $('.epaync-partial-refund input').removeAttr('disabled');
            $('.epaync-partial-refund').show();
        }
    });

    // Do not allow refund if no credit slip is generated or if a voucher is generated.
    function toggleStandardCheckboxDisplay() {
        if ($('#generateCreditSlip').is(':checked')
            && ! $('#generateDiscount').is(':checked')) {
            $('#doStandardRefundEpaync').removeAttr('disabled');
            $('.epaync-standard-refund').show();
        } else {
            $('#doStandardRefundEpaync').attr('disabled', 'disabled');
            $('.epaync-standard-refund').hide();
        }
    }
</script>