{**
 * Copyright © Lyra Network.
 * This file is part of EpayNC plugin for PrestaShop. See COPYING.md for license details.
 *
 * @author    Lyra Network (https://www.lyra.com/)
 * @copyright Lyra Network
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *}

{if version_compare($smarty.const._PS_VERSION_, '1.6', '>=')}
  <div class="row"><div class="col-xs-12{if version_compare($smarty.const._PS_VERSION_, '1.6.0.11', '<')} col-md-6{/if}">
{/if}

<div class="payment_module epaync {$epaync_tag|escape:'html':'UTF-8'}">
  {if $epaync_std_card_data_mode == 1 && !$epaync_is_valid_std_identifier}
    <a href="javascript: $('#epaync_standard').submit();" title="{l s='Click here to pay by credit card' mod='epaync'}">
  {else}
    <a class="unclickable"
      {if $epaync_is_valid_std_identifier}
        title="{l s='Choose pay with registred means of payment or enter payment information and click « Pay » button' mod='epaync'}"
      {else}
        title="{l s='Enter payment information and click « Pay » button' mod='epaync'}"
      {/if}
    >
  {/if}
    <img class="logo" src="{$epaync_logo|escape:'html':'UTF-8'}" />{$epaync_title|escape:'html':'UTF-8'}
    {if $epaync_is_valid_std_identifier}
      <br /><br />
      {include file="./payment_std_oneclick.tpl"}
    {/if}

    <form action="{$link->getModuleLink('epaync', 'redirect', array(), true)|escape:'html':'UTF-8'}"
          method="post" id="epaync_standard"
          {if $epaync_is_valid_std_identifier} style="display: none;"{/if}
    >

      <input type="hidden" name="epaync_payment_type" value="standard" />

      {if $epaync_is_valid_std_identifier}
        <input id="epaync_payment_by_identifier" type="hidden" name="epaync_payment_by_identifier" value="1" />
      {/if}

      {if ($epaync_std_card_data_mode == 2)}
        <br />

        {assign var=first value=true}
        {foreach from=$epaync_avail_cards key="key" item="card"}
          <div class="epaync-pm">
            {if $epaync_avail_cards|@count == 1}
              <input type="hidden" id="epaync_card_type_{$key|escape:'html':'UTF-8'}" name="epaync_card_type" value="{$key|escape:'html':'UTF-8'}" >
            {else}
              <input type="radio" id="epaync_card_type_{$key|escape:'html':'UTF-8'}" name="epaync_card_type" value="{$key|escape:'html':'UTF-8'}" style="vertical-align: middle;"{if $first == true} checked="checked"{/if} >
            {/if}

            <label for="epaync_card_type_{$key|escape:'html':'UTF-8'}">
              <img src="{$card['logo']}" alt="{$card['label']|escape:'html':'UTF-8'}" title="{$card['label']|escape:'html':'UTF-8'}" >
            </label>

            {assign var=first value=false}
          </div>
        {/foreach}
        <br />
        <div style="margin-bottom: 12px;"></div>

        {if $epaync_is_valid_std_identifier}
            <div>
                <ul>
                    {if $epaync_std_card_data_mode == 2}
                        <li>
                            <span class="epaync_span">{l s='You will enter payment data after order confirmation.' mod='epaync'}</span>
                        </li>
                    {/if}
                    <li style="margin: 8px 0px 8px;">
                        <span class="epaync_span">{l s='OR' mod='epaync'}</span>
                    </li>
                    <li>
                        <p class="epaync_link" onclick="epayncOneclickPaymentSelect(1)">{l s='Click here to pay with your registered means of payment.' mod='epaync'}</p>
                    </li>
                </ul>
            </div>
        {/if}

        {if version_compare($smarty.const._PS_VERSION_, '1.6', '<')}
          <input id="epaync_submit_form" type="submit" name="submit" value="{l s='Pay' mod='epaync'}" class="button"/>
        {else}
          <button id="epaync_submit_form" type="submit" name="submit" class="button btn btn-default standard-checkout button-medium">
            <span>{l s='Pay' mod='epaync'}</span>
          </button>
        {/if}
      {/if}
    </form>

    {if $epaync_is_valid_std_identifier}
      <script type="text/javascript">
        $('#epaync_standard_link').click(function(){
          {if ($epaync_std_card_data_mode == 2)}
            $('#epaync_submit_form').click();
          {else}
            $('#epaync_standard').submit();
          {/if}
        });
      </script>
    {/if}
  </a>
</div>

{if version_compare($smarty.const._PS_VERSION_, '1.6', '>=')}
  </div></div>
{/if}