{**
 * Copyright © Lyra Network.
 * This file is part of EpayNC plugin for PrestaShop. See COPYING.md for license details.
 *
 * @author    Lyra Network (https://www.lyra.com/)
 * @copyright Lyra Network
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *}

{if version_compare($smarty.const._PS_VERSION_, '1.6', '>=')}
<div class="row"><div class="col-xs-12{if version_compare($smarty.const._PS_VERSION_, '1.6.0.11', '<')} col-md-6{/if}">
{/if}

<div class="payment_module epaync {$epaync_tag|escape:'html':'UTF-8'}">
{if $epaync_is_valid_std_identifier}
  <a class="unclickable epaync-standard-link" title="{l s='Choose pay with registred means of payment or enter payment information and click « Pay » button' mod='epaync'}">
    <img class="logo" src="{$epaync_logo|escape:'html':'UTF-8'}" />{$epaync_title|escape:'html':'UTF-8'}
{else}
  <a href="javascript: void(0);" title="{l s='Click here to pay by credit card' mod='epaync'}" id="epaync_standard_link" class="epaync-standard-link">
    <img class="logo" src="{$epaync_logo|escape:'html':'UTF-8'}" />{$epaync_title|escape:'html':'UTF-8'}
    <br />
{/if}

    {if $epaync_is_valid_std_identifier}
      <br /><br />
      {include file="./payment_std_oneclick.tpl"}
      <input id="epaync_payment_by_identifier" type="hidden" name="epaync_payment_by_identifier" value="1" />
    {/if}

    <iframe class="epaync-iframe" id="epaync_iframe" src="{$link->getModuleLink('epaync', 'iframe', ['content_only' => 1], true)|escape:'html':'UTF-8'}" style="display: none;">
    </iframe>

    {if $epaync_can_cancel_iframe}
        <button class="epaync-iframe" id="epaync_cancel_iframe" style="display: none;">{l s='< Cancel and return to payment choice' mod='epaync'}</button>
    {/if}
  </a>

  <script type="text/javascript">
    var done = false;
    function epayncShowIframe() {
      if (done) {
        return;
      }

      done = true;

      {if !$epaync_is_valid_std_identifier}
        $('#epaync_iframe').parent().addClass('unclickable');
      {/if}

      $('.epaync-iframe').show();
      $('#epaync_oneclick_payment_description').hide();

      var url = "{$link->getModuleLink('epaync', 'redirect', ['content_only' => 1], true)|escape:'url':'UTF-8'}";
      {if $epaync_is_valid_std_identifier}
            url = url + '&epaync_payment_by_identifier=' + $('#epaync_payment_by_identifier').val();
      {/if}

      $('#epaync_iframe').attr('src', decodeURIComponent(url) + '&' + Date.now());
    }

    function epayncHideIframe() {
      if (!done) {
        return;
      }

      done = false;

      {if !$epaync_is_valid_std_identifier}
        $('#epaync_iframe').parent().removeClass('unclickable');
      {/if}

      $('.epaync-iframe').hide();
      $('#epaync_oneclick_payment_description').show();

      var url = "{$link->getModuleLink('epaync', 'iframe', ['content_only' => 1], true)|escape:'url':'UTF-8'}";
      $('#epaync_iframe').attr('src', decodeURIComponent(url) + '&' + Date.now());
    }

    $(function() {
      $('#epaync_standard_link').click(epayncShowIframe);
      $('#epaync_cancel_iframe').click(function() {
        epayncHideIframe();
        return false;
      });

      $('.payment_module a:not(.epaync-standard-link)').click(epayncHideIframe);
    });
  </script>
</div>

{if version_compare($smarty.const._PS_VERSION_, '1.6', '>=')}
</div></div>
{/if}