{**
 * Copyright © Lyra Network.
 * This file is part of EpayNC plugin for PrestaShop. See COPYING.md for license details.
 *
 * @author    Lyra Network (https://www.lyra.com/)
 * @copyright Lyra Network
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *}

<div style="padding-left: 40px;" id="epaync_oneclick_payment_description">
  <ul id="epaync_oneclick_payment_description_1">
    <li>
      <span class="epaync_span">{l s='You will pay with your registered means of payment' mod='epaync'}<b> {$epaync_saved_payment_mean|escape:'html':'UTF-8'}. </b>{l s='No data entry is needed.' mod='epaync'}</span>
    </li>

    <li style="margin: 8px 0px 8px;">
      <span class="epaync_span">{l s='OR' mod='epaync'}</span>
    </li>

    <li>
      <p class="epaync_link" onclick="epayncOneclickPaymentSelect(0)">{l s='Click here to pay with another means of payment.' mod='epaync'}</p>
    </li>
  </ul>
{if ($epaync_std_card_data_mode == '2')}
  <script type="text/javascript">
    function epayncOneclickPaymentSelect(paymentByIdentifier) {
      if (paymentByIdentifier) {
        $('#epaync_oneclick_payment_description').show();
        $('#epaync_standard').hide();
        $('#epaync_payment_by_identifier').val('1');
      } else {
        $('#epaync_oneclick_payment_description').hide();
        $('#epaync_standard').show();
        $('#epaync_payment_by_identifier').val('0');
      }
    }
  </script>
{else}
  <ul id="epaync_oneclick_payment_description_2" style="display: none;">
    {if ($epaync_std_card_data_mode != '5') || ($epaync_std_card_data_mode == '6')}
      <li>{l s='You will enter payment data after order confirmation.' mod='epaync'}</li>
    {/if}

      <li style="margin: 8px 0px 8px;">
        <span class="epaync_span">{l s='OR' mod='epaync'}</span>
      </li>
      <li>
        <p class="epaync_link" onclick="epayncOneclickPaymentSelect(1)">{l s='Click here to pay with your registered means of payment.' mod='epaync'}</p>
      </li>
  </ul>

  <script type="text/javascript">
    $(document).ready(function() {
       sessionStorage.setItem('epayncIdentifierToken', "{$epaync_rest_identifier_token|escape:'html':'UTF-8'}");
       sessionStorage.setItem('epayncToken', "{$epaync_rest_form_token|escape:'html':'UTF-8'}");
    });

    function epayncOneclickPaymentSelect(paymentByIdentifier) {
      if (paymentByIdentifier) {
        $('#epaync_oneclick_payment_description_1').show();
        $('#epaync_oneclick_payment_description_2').hide()
        $('#epaync_payment_by_identifier').val('1');
      } else {
        $('#epaync_oneclick_payment_description_1').hide();
        $('#epaync_oneclick_payment_description_2').show();
        $('#epaync_payment_by_identifier').val('0');
      }

      {if ($epaync_std_card_data_mode == '5' || $epaync_std_card_data_mode == '6')}
        $('.epaync .kr-form-error').html('');

        var token;
        if ($('#epaync_payment_by_identifier').val() == '1') {
          token = sessionStorage.getItem('epayncIdentifierToken');
        } else {
          token = sessionStorage.getItem('epayncToken');
        }

        KR.setFormConfig({ formToken: token, language: EPAYNC_LANGUAGE });
      {/if}
    }
    </script>
{/if}

{if ($epaync_std_card_data_mode != '5' && $epaync_std_card_data_mode != '6')}
    {if version_compare($smarty.const._PS_VERSION_, '1.6', '<')}
      <input id="epaync_standard_link" value="{l s='Pay' mod='epaync'}" class="button" />
    {else}
      <button id="epaync_standard_link" class="button btn btn-default standard-checkout button-medium">
        <span>{l s='Pay' mod='epaync'}</span>
      </button>
    {/if}
{/if}
</div>