{**
 * Copyright © Lyra Network.
 * This file is part of EpayNC plugin for PrestaShop. See COPYING.md for license details.
 *
 * @author    Lyra Network (https://www.lyra.com/)
 * @copyright Lyra Network
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *}

<!-- This meta tag is mandatory to avoid encoding problems caused by \PrestaShop\PrestaShop\Core\Payment\PaymentOptionFormDecorator -->
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />

<section style="margin-top: -12px;">
  <iframe class="epaync-iframe" id="epaync_iframe" src="{$link->getModuleLink('epaync', 'iframe', array(), true)|escape:'html':'UTF-8'}" style="display: none;">
  </iframe>

   {if $epaync_can_cancel_iframe}
       <a id="epaync_cancel_iframe" class="epaync-iframe" style="margin-bottom: 8px; display: none;" href="javascript:epayncInit();">
           {l s='< Cancel and return to payment choice' mod='epaync'}
       </a>
   {/if}
</section>
<br />

<script type="text/javascript">
  var epayncSubmit = function(e) {
    e.preventDefault();

    if (!$('#epaync_standard').data('submitted')) {
      $('#epaync_standard').data('submitted', true);
      $('#payment-confirmation button').attr('disabled', 'disabled');
      $('.epaync-iframe').show();
      $('#epaync_oneclick_payment_description').hide();

      var url = decodeURIComponent("{$link->getModuleLink('epaync', 'redirect', ['content_only' => 1], true)|escape:'url':'UTF-8'}") + '&' + Date.now();
      {if $epaync_is_valid_std_identifier}
        url = url + '&epaync_payment_by_identifier=' + $('#epaync_payment_by_identifier').val();
      {/if}

      $('#epaync_iframe').attr('src', url);
    }

    return false;
  }

  setTimeout(function() {
    $('input[type="radio"][name="payment-option"]').change(function() {
      epayncInit();
    });
  }, 0);

  function epayncInit() {
    if (!$('#epaync_standard').data('submitted')) {
      return;
    }

    $('#epaync_standard').data('submitted', false);
    $('#payment-confirmation button').removeAttr('disabled');
    $('.epaync-iframe').hide();
    $('#epaync_oneclick_payment_description').show();

    var url = decodeURIComponent("{$link->getModuleLink('epaync', 'iframe', ['content_only' => 1], true)|escape:'url':'UTF-8'}") + '&' + Date.now();
    $('#epaync_iframe').attr('src', url);
  }
</script>