{**
 * Copyright © Lyra Network.
 * This file is part of EpayNC plugin for PrestaShop. See COPYING.md for license details.
 *
 * @author    Lyra Network (https://www.lyra.com/)
 * @copyright Lyra Network
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *}

<!-- This meta tag is mandatory to avoid encoding problems caused by \PrestaShop\PrestaShop\Core\Payment\PaymentOptionFormDecorator -->
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />

<section style="margin-bottom: 2rem;">
<div id="epaync_oneclick_payment_description">
  <ul id="epaync_oneclick_payment_description_1">
    <li>
      <span>{l s='You will pay with your registered means of payment' mod='epaync'}<b> {$epaync_saved_payment_mean|escape:'html':'UTF-8'}. </b>{l s='No data entry is needed.' mod='epaync'}</span>
    </li>

    <li style="margin: 8px 0px 8px;">
      <span>{l s='OR' mod='epaync'}</span>
    </li>

    <li>
      <a href="javascript: void(0);" onclick="epayncOneclickPaymentSelect(0)">{l s='Click here to pay with another means of payment.' mod='epaync'}</a>
    </li>
  </ul>
{if ($epaync_std_card_data_mode == '2')}
  </div>
    <script type="text/javascript">
      function epayncOneclickPaymentSelect(paymentByIdentifier) {
        if (paymentByIdentifier) {
          $('#epaync_oneclick_payment_description_1').show();
          $('#epaync_standard').hide();
          $('#epaync_payment_by_identifier').val('1');
        } else {
          $('#epaync_oneclick_payment_description_1').hide();
          $('#epaync_standard').show();
          $('#epaync_payment_by_identifier').val('0');
         }
       }
     </script>
{else}
    <ul id="epaync_oneclick_payment_description_2" style="display: none;">
      {if ($epaync_std_card_data_mode != '5') || $epaync_std_card_data_mode == '6'}
        <li>{l s='You will enter payment data after order confirmation.' mod='epaync'}</li>
      {/if}

      <li style="margin: 8px 0px 8px;">
        <span>{l s='OR' mod='epaync'}</span>
      </li>
      <li>
        <a href="javascript: void(0);" onclick="epayncOneclickPaymentSelect(1)">{l s='Click here to pay with your registered means of payment.' mod='epaync'}</a>
      </li>
    </ul>
  </div>

  <script type="text/javascript">
    function epayncOneclickPaymentSelect(paymentByIdentifier) {
      if (paymentByIdentifier) {
        $('#epaync_oneclick_payment_description_1').show();
        $('#epaync_oneclick_payment_description_2').hide()
        $('#epaync_payment_by_identifier').val('1');
      } else {
        $('#epaync_oneclick_payment_description_1').hide();
        $('#epaync_oneclick_payment_description_2').show();
        $('#epaync_payment_by_identifier').val('0');
      }

      {if ($epaync_std_card_data_mode == '5' || $epaync_std_card_data_mode == '6')}
        $('.epaync .kr-form-error').html('');

        var token;
        if ($('#epaync_payment_by_identifier').val() == '1') {
          token = "{$epaync_rest_identifier_token|escape:'html':'UTF-8'}";
        } else {
          token = "{$epaync_rest_form_token|escape:'html':'UTF-8'}";
        }

        KR.setFormConfig({ formToken: token, language: EPAYNC_LANGUAGE });
      {/if}
    }
  </script>
{/if}
</section>

<script type="text/javascript">
  window.onload = function() {
      $("input[data-module-name=epaync]").change(function() {
        if ($(this).is(':checked')) {
          epayncOneclickPaymentSelect(1);
          if (typeof epayncSepaOneclickPaymentSelect == 'function') {
            epayncSepaOneclickPaymentSelect(1);
          }
        }
      });
  };
</script>