<?php
/**
 * 2007-2016 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@buy-addons.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    Buy-Addons <contact@buy-addons.com>
 *  @copyright 2007-2018 PrestaShop SA
 *  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 * @since 1.6
 */

class FacebookChat extends Module
{
    private $demoMode=false;
    public function __construct()
    {
        $this->name = 'facebookchat';
        $this->tab = 'front_office_features';
        $this->version = '1.0.10';
        $this->author = 'buy-addons';
        $this->need_instance = 0;
        $this->bootstrap = true;
        $this->module_key = '227087bb3c3cd5902ec77d4e5757726f';
        parent::__construct();
        $this->displayName = $this->l('Facebook Live Chat');
        $this->description = $this->l('Allow live chat on website via Facebook Messenger');
    }

    public function install()
    {
        if (parent::install() == false) {
            return false;
        }
        if ($this->registerHook("displayFooter") == false) {
            return false;
        }
        Configuration::UpdateValue('Settingfb', '{"URL":"","Height":"350","colorbackgr":"3B5998","colorword":"FFFFFF",
        "position":"rightdown","Enable":"TRUE","Hide_cover":"TRUE","show_avatar":"TRUE","Use_small":"TRUE",
        "Display":"TRUE","Open_mobile":"FALSE","Open_desktop":"TRUE"}');
        return true;
    }

    public function uninstall()
    {
        if (parent::uninstall() == false) {
            return false;
        }
        return true;
    }
    public function hookdisplayFooter(& $params)
    {
        $html = '';
        $id_lang = $this->context->language->id;
        $getidLang = Language::getLanguage($id_lang);
        $this->smarty->assign('getidLang', $getidLang);
        $getConfigTime = Configuration::get('Settingfb');
        $settingfb = Tools::jsonDecode($getConfigTime, true);
        //echo'<pre>';print_r($settingfb);die;
        $this->smarty->assign('settingfb', $settingfb);
        $language = Language::getLanguages(false);
        
        /////// l?y d?ng language code
        $tachchuoiLang = explode('-', $getidLang['language_code']);
        $sercondLang = Tools::strtoupper($tachchuoiLang[1]);
        $firstLang = $tachchuoiLang[0];
        $btnLikeLang = $firstLang.'_'.$sercondLang;
        $this->smarty->assign('btnLikeLang', $btnLikeLang);
        ////////
        $this->smarty->assign('arr_language', $language);
        if ($settingfb['Display'] == 'FALSE') {
            $this->smarty->assign("mobile_css", $this->_path . 'views/css/mobile.css');
        }
        if ($settingfb['Open_mobile'] == 'FALSE') {
            $this->smarty->assign("mobile1_css", $this->_path . 'views/css/mobile1.css');
        }
        if ($settingfb['Open_desktop'] == 'FALSE') {
            $this->smarty->assign("mobile2_css", $this->_path . 'views/css/mobile2.css');
        }
        if (strpos(_PS_VERSION_, '1.5') === 0) {
            $this->smarty->assign("stylecsshook_1_5_css", $this->_path . 'views/css/stylecsshook_1_5.css');
        }
        /// l?y giᡴr? 𠩮put da ng𮠮g?
        $BAEU_rightLinkText2 = array();
        $txtStart = array();
        $textArea = array();
        foreach ($language as $langAr) {
            $BAEU_rightLinkText2[] = Configuration::get('BAEU_rightLinkText_'.$langAr['id_lang']);
            $txtStart[] = Configuration::get('txtbtnStart'.$langAr['id_lang']);
            $textArea[] = Configuration::get('tareaWelcome'.$langAr['id_lang']);
        }
        $this->smarty->assign('txtStart', $txtStart);
        $this->smarty->assign('valueText', $BAEU_rightLinkText2);
        $this->smarty->assign('textArea', $textArea);
        /////////////
        $jquery_path = Media::getJqueryPath();
        $this->smarty->assign("mainpage_js", $this->_path . 'views/js/mainpage.js');
        $this->smarty->assign("jquery_path", $jquery_path);
        $this->smarty->assign("stylecsshook_css", $this->_path . 'views/css/stylecsshook.css');
        $html .= $this->display(__FILE__, 'views/templates/hook/message.tpl');
        return $html;
    }
    public function getcontent()
    {
        
        $html = '';
        $id_lang = $this->context->language->id;
        $id_default = (int) (Configuration::get('PS_LANG_DEFAULT'));
        $iso_default_language = Language::getIsoById($id_default);
        $language = Language::getLanguages(false);
        $buttonSubmitSaveArr = array(
            'Save',
        );
        
        $this->smarty->assign('demoMode', Tools::getValue('demoMode'));
        $this->smarty->assign('languagelg', $language);
        $this->smarty->assign('id_default', $id_default);
        $this->smarty->assign('id_default_language', $id_lang);
        $this->smarty->assign('iso_default_language', $iso_default_language);
        $this->smarty->assign('arr_language', $language);
        
        ////////th뭠giᡴr? khi 𠲿ng
        foreach ($language as $langAr) {
            if (Configuration::get('txtbtnStart'.$langAr['id_lang']) == "") {
                Configuration::updateValue('txtbtnStart'.$langAr['id_lang'], "Start");
            } if (Configuration::get('BAEU_rightLinkText_'.$langAr['id_lang']) == "") {
                Configuration::updateValue('BAEU_rightLinkText_'.$langAr['id_lang'], "Facebook Chat Support");
            } if (Configuration::get('tareaWelcome'.$langAr['id_lang']) == "") {
                $stringtxt = "Hi, Please click Start to chat to Our Administrator";
                Configuration::updateValue('tareaWelcome'.$langAr['id_lang'], $stringtxt);
            }
        }
        /////////
        $isoDefaultLanguage = Language::getIsoById($id_lang);
        if (Tools::isSubmit("Save")) {
            if (Tools::getvalue('txturl') == "") {
                $html .=$this->displayError("You enter the missing fields URL");
            }
            
            //// demomode
            $token=Tools::getAdminTokenLite('AdminModules');
            $bamodule=AdminController::$currentIndex;
            if ($this->demoMode==true) {
                foreach ($buttonSubmitSaveArr as $buttonSubmitSave) {
                    if (Tools::isSubmit($buttonSubmitSave)) {
                        Tools::redirectAdmin($bamodule.'&token='.$token.'&configure='.$this->name.'&demoMode=1');
                    }
                }
            }
            /////////
            foreach ($language as $langAr) {
                $BAEU_rightLinkText1 = Tools::getValue('BAEU_rightLinkText_'.$langAr['id_lang']);
                $SavecftxtHeader = Tools::getValue('txtbtnStart'.$langAr['id_lang']);
                $SaveTextArea = Tools::getValue('tareaWelcome'.$langAr['id_lang']);
                if ($langAr['iso_code'] != $isoDefaultLanguage) {
                    if (empty($BAEU_rightLinkText1)) {
                        $BAEU_rightLinkText1 = Tools::getValue('BAEU_rightLinkText_'.$langAr['id_lang']);
                    } if (empty($SavecftxtHeader)) {
                        $SavecftxtHeader = Tools::getValue('txtbtnStart'.$langAr['id_lang']);
                    } if (empty($SaveTextArea)) {
                        $SaveTextArea = Tools::getValue('tareaWelcome'.$langAr['id_lang']);
                    }
                }
                // echo'<pre>';print_r($langAr);die;
                Configuration::updateValue('BAEU_rightLinkText_'.$langAr['id_lang'], $BAEU_rightLinkText1);
                Configuration::updateValue('txtbtnStart'.$langAr['id_lang'], $SavecftxtHeader);
                Configuration::updateValue('tareaWelcome'.$langAr['id_lang'], $SaveTextArea);
            }
            $SaveSettingFb = array(
                'URL'=>Tools::getValue('txturl'),
                'Height'=>Tools::getValue('txtheight'),
                'colorbackgr'=>Tools::getValue('txtcolorbackground'),
                'colorword'=>Tools::getValue('txtcolorfont'),
                'position' =>Tools::getValue('position'),
                'Enable'=>Tools::getValue('Enable'),
                'Hide_cover'=>Tools::getValue('Hide_cover'),
                'show_avatar'=>Tools::getValue('show_avatar'),
                'Use_small'=>Tools::getValue('Use_small'),
                'Display'=>Tools::getValue('Display'),
                'Open_mobile'=>Tools::getValue('Open_mobile'),
                'Open_desktop'=>Tools::getValue('Open_desktop'),
            );
            $ToStr = Tools::jsonEncode($SaveSettingFb);
            Configuration::UpdateValue('Settingfb', $ToStr);
            Tools::jsonDecode($ToStr, true);
            
            if (Configuration::UpdateValue('Settingfb', $ToStr) == 1) {
                $html .= $this->displayConfirmation($this->l('Update successful'));
            }
            foreach ($language as $langAr) {
                $BAEU_rightLinkText = Configuration::get('BAEU_rightLinkText_'.$langAr['id_lang']);
                $txtbtnStart = Configuration::get('txtbtnStart'.$langAr['id_lang']);
                $tareaWelcome = Configuration::get('tareaWelcome'.$langAr['id_lang']);
                $this->smarty->assign('BAEU_rightLinkText_'.$langAr['id_lang'], $BAEU_rightLinkText);
                $this->smarty->assign('tareaWelcome'.$langAr['id_lang'], $tareaWelcome);
                $this->smarty->assign('txtbtnStart'.$langAr['id_lang'], $txtbtnStart);
                $str = "BAEU_rightLinkText_";
                $str1 = "txtbtnStart";
                $str2 = "tareaWelcome";
                if (Configuration::get($str.$langAr['id_lang']) == "" && Configuration::get($str.$id_default) != "") {
                    Configuration::updateValue($str.$langAr['id_lang'], Configuration::get($str.$id_default));
                } if (Configuration::get($str1.$langAr['id_lang']) == ""&&Configuration::get($str1.$id_default) != "") {
                    Configuration::updateValue($str1.$langAr['id_lang'], Configuration::get($str1.$id_default));
                } if (Configuration::get($str2.$langAr['id_lang']) == ""&&Configuration::get($str2.$id_default) != "") {
                    Configuration::updateValue($str2.$langAr['id_lang'], Configuration::get($str2.$id_default));
                }
            }
        }
        //////k?t th򣠮򴠓ave
        /// l?y giᡴr? 𠩮put da ng𮠮g?
        $BAEU_rightLinkText2 = array();
        $txtStart = array();
        $textArea = array();
        foreach ($language as $langAr) {
            $BAEU_rightLinkText2[] = Configuration::get('BAEU_rightLinkText_'.$langAr['id_lang']);
            $txtStart[] = Configuration::get('txtbtnStart'.$langAr['id_lang']);
            $textArea[] = Configuration::get('tareaWelcome'.$langAr['id_lang']);
        }
        $this->smarty->assign('txtStart', $txtStart);
        $this->smarty->assign('valueText', $BAEU_rightLinkText2);
        $this->smarty->assign('textArea', $textArea);
        ////////
        
        $language_default = Configuration::get('BAEU_rightLinkText_'.$id_default);
        $this->smarty->assign('language_default', $language_default);
        $getConfigTime = Configuration::get('Settingfb');
        $settingfb = Tools::jsonDecode($getConfigTime, true);
        $this->smarty->assign('settingfb', $settingfb);
        $this->smarty->assign('version', strpos(_PS_VERSION_, '1.5'));
        // echo'<pre>';print_r($settingfb);die;
        $html .= '
            <script type="text/javascript">
                var txtheader=\'' . $id_default . '\';
            </script>
        ';
        if (strpos(_PS_VERSION_, '1.5') === 0) {
            $this->context->controller->addJS($this->_path . 'views/js/admin_1_5.js');
            $this->context->controller->addCSS($this->_path . 'views/css/styleadmin_1_5.css');
            $this->context->controller->addJS($this->_path . 'views/js/common_1_5.js');
        } else {
            $this->context->controller->addCSS($this->_path . 'views/css/stylecssmain.css');
            $this->context->controller->addJS($this->_path . 'views/js/common.js');
        }
        $this->context->controller->addJS($this->_path . 'views/js/jscolor.js');
        
        $this->context->controller->addJS($this->_path . 'views/js/admin.js');
        $html .= $this->display(__FILE__, 'views/templates/admin/admin.tpl');
        
        return $html;
    }
}
