/**
 * 2007-2019 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@buy-addons.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    Buy-addons    <contact@buy-addons.com>
 * @copyright 2007-2019 Buy-addons
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

function setCookie(cname, cvalue, exdays) {
    var d = new Date();
    d.setTime(d.getTime() + (exdays*1000));
    var expires = "expires="+d.toUTCString();
    document.cookie = cname + "=" + cvalue + "; " + expires;
}
function getCookie(cname) {
    var name = cname + "=";
    var ca = document.cookie.split(';');
    for(var i=0; i<ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0)==' ') c = c.substring(1);
        if (c.indexOf(name) == 0) return c.substring(name.length,c.length);
    }
    return "";
}

jQuery(document).ready(function () {
	
	if(getCookie("cookie_js")=="" || getCookie("cookie_js")== 1){
		var cvalue = 1;
		var exdays = 24*60*60;
		setCookie("cookie_js", cvalue, exdays);	
	}
	
	$('.btnstart').click(function(){
		var cvalue = parseInt(getCookie("cookie_js")) + 1;
		setCookie("cookie_js", cvalue, 24*60*60);
		if(getCookie("cookie_js") == 1){
			$('.div_startchat').show();
		} else {
			$('.div_startchat').hide();
		}
	});
	if(getCookie("cookie_js") == 1){
		$('.div_startchat').show();
	} else {
		$('.div_startchat').hide();
	}
	
	if(getCookie("close")=="" || getCookie("cookie_js")== 1){
		setCookie("close", cvalue, exdays);	
	}
	
	$('#header_fblivechat').click(function(){
		$('#content_fblivechat').toggle();
	});
	$('#btn_close_fblive').click(function(){
		$('#all_fblivechat').hide();
		$('#open_fblivechat').show();
	});
	$('#open_fblivechat').click(function(){
		$('#open_fblivechat').hide();
		$('#all_fblivechat').show();
		$('#content_fblivechat').show();
	});

})