/**
 * 2007-2020 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2020 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 */
import $ from 'jquery';
import prestashop from 'prestashop';
import ProductSelect from './components/product-select';



$(document).ready(function () {
  createProductSpin();
  createInputFile();
  closeGallery();
  openReviewTab();
  updateCountdown();


  function producSlick() {

    $('#content-wrapper .js-qv-mask ul').slick({
      dots: false,
      arrows: true,
      vertical: true,
      slidesToShow: 4,
      slidesToScroll: 1,
      infinite: true,
    });



  }


  $('#content-wrapper .js-qv-mask ul').slick({
    dots: false,
    arrows: true,
    vertical: true,
    slidesToShow: 4,
    slidesToScroll: 1,
    infinite: true,
  });

  $('.product-images .slick-list').wrap('<div class="slick-list-wrap"></div>');
  if ($('#content-wrapper .js-qv-mask .slick-slide').length > 4) {
    $('#content-wrapper .js-qv-mask .slick-list').css('padding-top', '2px');
  }

  prestashop.on('updatedProduct', function (event) {

    createInputFile();

    producSlick();
    if ($('.thumb-container.slick-slide').length > 4) {
      $('#content-wrapper .js-qv-mask ul .slick-list.draggable').css('padding-top', '5px');

    }

    updateCountdown();
    applyElevateZoom();
    $('.product-images .slick-list').wrap('<div class="slick-list-wrap"></div>');
    $('.product-images .slick-prev').trigger('click');
    $('.color-boxes').parent().css('overflow', 'hidden');
    if (event && event.product_minimal_quantity) {
      const minimalProductQuantity = parseInt(event.product_minimal_quantity, 10);
      const quantityInputSelector = '#quantity_wanted';
      let quantityInput = $(quantityInputSelector);
      // @see http://www.virtuosoft.eu/code/bootstrap-touchspin/ about Bootstrap TouchSpin
      quantityInput.trigger('touchspin.updatesettings', {
        min: minimalProductQuantity
      });
    }
    $('.thumb-container').click(
      function () {
        restartElevateZoom();
      }
    );

    $($('.tabs .nav-link.active').attr('href')).addClass('active').removeClass('fade');
    $('.js-product-images-modal').replaceWith(event.product_images_modal);

    let productSelect = new ProductSelect();
    productSelect.init();
  });
});

function updateCountdown() {

  $('#bon-stick-cart .bon-stock-countdown').remove();
  let maxQuantity = parseInt($('.bon-stock-countdown').attr("data-max"));
  let quantityProduct = parseInt($('.bon-stock-countdown-counter').attr('data-value'));
  let progressBar = $('.bon-stock-countdown-progress');

  if (quantityProduct < maxQuantity) {
    if (quantityProduct > 0) {
      $(progressBar).css('width', (quantityProduct * 100) / maxQuantity + '%');
    }
  }

  if (quantityProduct > maxQuantity) {
    $(progressBar).css('width', '100%');
  }

  if (quantityProduct <= 0) {
    $('.bon-stock-countdown-title').html('<span>No product available!</span>');
    $(progressBar).css('width', '0');
  }
}




function closeGallery() {
  $(document).mouseup(function (e) {
    var gallery = $("#bon-modal-gallery");
    var modalBg = $('.modal-backdrop');

    if (gallery.is(e.target) &&
      gallery.has(e.target).length === 0) {
      gallery.hide();
    }

    $('.js-modal-product-images, .bon-gallery-wrapper').attr("data-dismiss", "modal").children().click(function (e) {
      return false;
    });
  });

}



function openReviewTab() {
  let tabs = $('.nav-item a');
  $('.bon-review-button').on('click', function () {
    if ($(tabs).hasClass('active')) {
      $(tabs).removeClass('active');
      $('.nav-item .reviewtab').trigger('click');
    } else {
      $('.nav-item .reviewtab').removeClass('active');
    }

  })
}



function createInputFile() {
  $('.js-file-input').on('change', (event) => {
    let target, file;

    if ((target = $(event.currentTarget)[0]) && (file = target.files[0])) {
      $(target).prev().text(file.name);
    }
  });
}

function createProductSpin() {
  const $quantityInput = $('#quantity_wanted');

  $quantityInput.TouchSpin({
    buttondown_class: 'btn btn-touchspin js-touchspin',
    buttonup_class: 'btn btn-touchspin js-touchspin',
    verticalbuttons: true,
    min: parseInt($quantityInput.attr('min'), 10),
    max: 1000000
  });
}