<?php
/**
 * 2015-2021 Bonpresta
 *
 * Bonpresta Instagram Carousel Social Feed Photos
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the General Public License (GPL 2.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/GPL-2.0
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade the module to newer
 * versions in the future.
 *
 *  @author    Bonpresta
 *  @copyright 2015-2021 Bonpresta
 *  @license   http://opensource.org/licenses/GPL-2.0 General Public License (GPL 2.0)
 */

require_once('../../../../config/config.inc.php');
require_once('../../../../init.php');
require_once('../../boninstagramslick.php');

$BASE_DIR = _MODULE_DIR_;

echo '<script
    src="https://code.jquery.com/jquery-3.6.0.min.js"
    integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4="
    crossorigin="anonymous"></script>';

if (Configuration::get('BONINSTAGRAMSLICK_TYPE') == 'user') {
    echo '<script>
    var data = {};
    let i = 1;
    var imgName;

    $.get(
        "https://images" +
        ~~(Math.random() * 9999) +
        "-focus-opensocial.googleusercontent.com" +
        "/gadgets/proxy?container=none&url=https:" +
        "//www.instagram.com/'.Configuration::get('BONINSTAGRAMSLICK_USERID').'/",
        function (json) {
            var pattern = /_sharedData = ({.*);<\/script>/m,
                json = JSON.parse(pattern.exec(json)[1]),
                edges =
                    json.entry_data.ProfilePage[0].graphql.user
                        .edge_owner_to_timeline_media.edges;
            var count = 0;

            $.each(edges, function name(j, examp) {
                if (count >= '.Configuration::get('BONINSTAGRAMSLICK_LIMIT').')  {
                    return false;
                }
                count++;
                let img = encodeURI(examp.node.thumbnail_src);
                imgName = "sample-";
                imgName = imgName + i;
                i++;
                data = {
                    url: img,
                    imgName: imgName
                }
                $.ajax({
                    type: "POST",
                    data: JSON.stringify(data),
                    dataType: "JSON",
                    url: "'.$BASE_DIR.'/boninstagramslick/controllers/back/insta_parser.php",
                    success: function(msg) {
                        console.log(msg)
                    },
                    failure : function(msg) {
                    }
                });
            });
        }
    );
    </script>';
} elseif (Configuration::get('BONINSTAGRAMSLICK_TYPE') == 'tagged') {
    echo '<script>
    var data = {};
    let i = 1;
    var imgName;

    $.get(
        "https://images" +
        ~~(Math.random() * 9999) +
        "-focus-opensocial.googleusercontent.com/" +
        "gadgets/proxy?container=none&url=https://" +
        "www.instagram.com/explore/tags/'.Configuration::get('BONINSTAGRAMSLICK_TAG').'/",
        function (json) {
            var pattern = /_sharedData = ({.*);<\/script>/m,
                json = JSON.parse(pattern.exec(json)[1]),
                edges =
                    json.entry_data.TagPage[0].graphql.hashtag.edge_hashtag_to_media.edges;
            var count = 0;

            $.each(edges, function name(j, examp) {
                if (count >= '.Configuration::get('BONINSTAGRAMSLICK_LIMIT').') {
                    return false;
                }
                count++;
                let img = encodeURI(examp.node.thumbnail_src);
                imgName = "sample-";
                imgName = imgName + i;
                i++;
                data = {
                    url: img,
                    imgName: imgName
                }
                $.ajax({
                    type: "POST",
                    data: JSON.stringify(data),
                    dataType: "JSON",
                    url: "'.$BASE_DIR.'/boninstagramslick/controllers/back/insta_parser.php",
                    success: function(msg) {
                        console.log(msg)
                    },
                    failure : function(msg) {
                    }
                });
            });
        }
    );
    </script>';
}
